package com.oreilly.servlet;
import java.io.*;
import java.net.*;
import javax.servlet.*;

public class ServletUtils {

// Przelij zawarto pliku do strumienia wyjciowego
public static void returnFile(String filename, OutputStream out)
                     throws FileNotFoundException, IOException {
   // FileInputStream jest zwizany z bajtami
   FileInputStream fis = null;
   try {
      fis = new FileInputStream(filename);
      byte[] buf = new byte[4 * 1024]; //bufor 4K
      int bytesRead;
      while ((bytesRead = fis.read(buf)) != -1) {
         out.write(buf, 0, bytesRead);
      }
   }
   finally {
      if (fis != null) fis.close();
   }
  }

// Przesya treci URL do OutputStream
public static void returnURL(URL url,OutputStream out)throws
                 IOException {
   InputStream in = url. openStream () ;
   byte[] buf = new byte[4 * 1024]; //bufor 4K
   int bytesRead;
   while ((bytesRead = in.read(buf)) != -1) {
      out.write(buf, 0, bytesRead);
   }
}

// Przesya treci URL do PrintWriter
public static void returnURL(URL url, PrintWriter out) throws IOException {
   // Okrel kodowanie zawartoci URL
   URLConnection con = url.openConnection() ;
   con.connect();
   String encoding = con.getContentEncoding() ;

   // Utwrz Reader odpowiedni dla tego kodowania
   BufferedReader in = null;
   if (encoding == null) {
      in = new BufferedReader(
           new InputStreamReader(url.openStream())) ;
   }
    else {
    in = new BufferedReader(
         new InputStreamReader(url.openStream(), encoding));
}
    char[] buf = new char[4 * 1024];  // bufor 4Kchar
    int charsRead;
    while ((charsRead = in.read(buf)) != -1) {
       out.write(buf, 0, charsRead);
  }
 }

public static URL getResource(ServletContext context, String resource)
                                             throws IOException {
   // Zwarcie jeeli zasb wynosi zero
   if (resource == null) {
      throw new FileNotFoundException(
         "dany zasb wynosi null (przekazano null)");
   }

   if (resource.endsWith("/") ||
       resource.endsWith("\\")||
       resource.endsWith(".")) {
      throw new MalformedURLException("cieka nie moe si koczy ukonikiem lub kropk");
   }

   if (resource. indexOf ("..") != -1) {
      throw new MalformedURLException("cieka nie moe zawiera podwjnych kropek");
   }

   String upperResource = resource.toUpperCase() ;
   if (upperResource.startsWith("/WEB-INF") ||
       upperResource. startsWith ("/META-INF")) {
   throw new MalformedURLException(
     "cieka nie moe zaczyna si na  /WEB-INF lub /META-INF") ;
   }

   if (upperResource.endsWith(".JSP")) {
    throw new MalformedURLException(
    "cieka nie moe koczy si na .jsp") ;
   }

   // Konwertuj zasb na URL
   URL url = context.getResource(resource);
   if (url == null) {
      throw new FileNotFoundException("dany zasb by rwny null (" + resource  + ")");
   }

   return url;
}

public static String getStackTraceAsString(Throwable t) {
   ByteArrayOutputStream bytes = new ByteArrayOutputStream();
   PrintWriter writer = new PrintWriter(bytes, true);
   t.printStackTrace(writer) ;
   return bytes.toString() ;
}


}