package com.oreilly.servlet;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;


public abstract class CacheHttpServlet  extends HttpServlet {

 CacheHttpServletResponse cacheResponse;
 long cacheLastMod = -1;
 String cacheQueryString = null;
 String cachePathInfo = null;
 String cacheServletPath = null;
 Object lock = new Object();

protected   void service (HttpServletRequest  req, HttpServletResponse res)
   throws ServletException, IOException {
 //Tylko dla zlece GET korzystaj z buforowania
 String method = req.getMethod();
 if(!method.equals("GET")) {
   super.service(req, res);
   return ;
 }

  // Sprawd czas ostatniej modyfikacji serwletu
  long servletLastMod = getLastModified(req);

  // Ostatnio zmodyfikowany 1 oznacza, e nie powinnimy w ogle uywa pamici podrcznej
  if(servletLastMod == -1) {
   super.service(req, res);
    return ;
 }

  // jeeli klient przysa nagwek If-Modified-Since, w lub po
  // czasie ostatniej modyfikacji serwletu przelij krtki kod statusu
  // "Nie zmodyfikowany". Zaokrgl do najbliszej sekundy
  // jako e nagwki klienta s w sekundach

   if ((servletLastMod / 1000 * 1000) <=
        req.getDateHeader("If-Modified-Since")) {

     res.setStatus(res.SC_NOT_MODIFIED);
     return ;
   }

   // Wykorzystaj istniejc pami podrczn jeeli jest ona aktualna i poprawna
   CacheHttpServletResponse localResponseCopy = null;
 synchronized(lock) {
       if (servletLastMod <= cacheLastMod &&
                             cacheResponse.isValid() &&
          equal (cacheQueryString, req.getQueryString()) &&
          equal (cachePathInfo, req.getPathInfo()) &&
          equal (cacheServletPath, req.getServletPath())) {
            localResponseCopy = cacheResponse;
     }
 }

 if (localResponseCopy != null) {
   localResponseCopy.writeTo(res);
   return ;
 }

 // W przeciwnym razie utwrz nowy bufor, aby zachowa odpowied
  localResponseCopy = new CacheHttpServletResponse(res);
 super.service(req, localResponseCopy);

synchronized (lock) {
    cacheResponse = localResponseCopy;
    cacheLastMod = servletLastMod;
    cacheQueryString = req.getQueryString();
    cachePathInfo = req.getPathInfo();
    cacheServletPath = req.getServletPath();
 }
}

   private boolean equal(String s1, String  s2) {
     if (s1 == null && s2 == null) {
      return true;
     }
     else if (s1 == null || s2 == null) {
       return false;
}
else {
  return s1.equals(s2);
    }
   }
 }

class CacheHttpServletResponse implements HttpServletResponse {
  // Przechowuj kluczowe zmienne odpowiedzi w celu
  // wstawienia ich pniej
 private int status;
 private Hashtable headers;
private int contentLength;
private String contentType;
private Locale locale;
private Vector cookies;
private boolean didError;
private boolean didRedirect;
private boolean gotStream;
private boolean gotWriter;

   private HttpServletResponse delegate;
   private CacheServletOutputStream out;
  private PrintWriter writer;
  
CacheHttpServletResponse(HttpServletResponse res) {
  delegate = res;
    try {
     out = new CacheServletOutputStream(res.getOutputStream());

    }
   catch (IOException e) {
     System.out.println (
       "Wystpi wyjtek IOException tworzc odpowied z pamici podrcznej: "      
      + e.getMessage());
}
 internalReset();
}

private void internalReset() {
  status = 200;
   headers = new Hashtable();
   contentLength = -1;
   contentType = null;
   locale = null;
   cookies = new Vector();
   didError = false;
   didRedirect = false;
   gotStream = false;
   gotWriter = false;
   out.getBuffer().reset();
}

public boolean isValid() {

// Nie przechowujemy w pamici podrcznej stron z bdami
// lub przekierowaniami
   return didError != true && didRedirect !=true;
}

private void internalSetHeader(String name, Object value) {
  Vector v = new Vector();
   v.addElement(value);
   headers.put(name, v);
}


private void internalAddHeader(String name, Object value) {
  Vector v = (Vector) headers.get(name);
   if (v == null ) {
     v = new Vector();
   }
   v.addElement(value);
   headers.put(name, v);
 }

public void writeTo(HttpServletResponse res) {
   // Zapisz kod statusu   
   res.setStatus(status);
  // Zapisz nagwki upraszczajce
 if (contentType != null) res.setContentType(contentType);
   if (locale != null) res.setLocale(locale);
   // Zapisz cookies
   Enumeration enum = cookies.elements();
   while (enum.hasMoreElements()) {
     Cookie c =(Cookie) enum.nextElement();
     res.addCookie(c);
   }
   // Zapisz nagwki standardowe
    enum = headers.keys();

while(enum.hasMoreElements()) {
     String name = (String) enum.nextElement();
     Vector values = (Vector) headers.get(name); // moe mie wielokrotne wartoci
     Enumeration enum2 = values.elements();
    while (enum2.hasMoreElements()) {
       Object value = enum2.nextElement();
           if(value instanceof String ) {
               res.setHeader(name, (String )value);

       }
             if(value instanceof Integer ) {
               res.setIntHeader(name, ((Integer)value).intValue());
}

             if(value instanceof Long ) {
                 res.setDateHeader(name, ((Long )value).longValue());
              }
    }
 }
     // Zapisz dugo zawartoci
    res.setContentLength(out.getBuffer().size());
     // Zapisz tre
   try { 
        out.getBuffer().writeTo(res.getOutputStream());
   }
   catch (IOException e) {
     System.out.println("Wystpi wyjtek IOException na pisemn odpowied tekstow z pamici  podrcznej: " 
                                        + e.getMessage());
   }
 }

public ServletOutputStream getOutputStream() throws IOException {
      if (gotWriter) {
        throw new IllegalStateException(
           "Niemoliwy do otrzymania strumie wyjciowy po uzyskaniu wykonawcy zapisu");
   }
   gotStream = true;
   return out;
}

  public PrintWriter getWriter() throws UnsupportedEncodingException {
     if (gotStream) {
             throw new IllegalStateException(
               "Niemoliwy do otrzymania wykonawca zapisu po uzyskaniu strumienia wyjciowego");
   }
   gotWriter = true;
   if (writer == null) {
 
   OutputStreamWriter w =
     new OutputStreamWriter(out, getCharacterEncoding());
   writer = new PrintWriter(w, true); // konieczne jest automatyczne 
                                      // oprnienie pamici podrcznej
   }
   return writer;
 } 

  public void setContentLength(int len) {
                     delegate.setContentLength(len);
                  // Nie ma potrzeby zapisywania dugoci,
                  // moemy obliczy to pniej
   }

    public void setContentType(String type) {
       delegate.setContentType(type);
       contentType = type;
     }

 public String getCharacterEncoding () {
      return delegate.getCharacterEncoding ();
   }

public void setBufferSize(int size) throws IllegalStateException {
   delegate.setBufferSize(size);
 }

public int getBufferSize() {
     return delegate.getBufferSize();
 }

public void reset() throws IllegalStateException {
   delegate.reset();
    internalReset();
}


public void resetBuffer() throws IllegalStateException {
   delegate.resetBuffer();
}

public boolean isCommitted() {
   return delegate.isCommitted();
}

public void flushBuffer() throws IOException {
   delegate.flushBuffer();
}

public void setLocale(Locale loc) {
   delegate.setLocale(loc);
   locale = loc;
}


public Locale getLocale(){
return delegate.getLocale();
}

public void addCookie(Cookie cookie) {
   delegate.addCookie(cookie);
   cookies.addElement(cookie);
}

public boolean containsHeader(String name) {
   return delegate.containsHeader(name);
}

/**@deprecated*/
public void setStatus(int sc, String sm) {
   delegate.setStatus(sc, sm);
  status = sc;
}

public void setStatus(int sc) {
   delegate.setStatus(sc);
   status = sc;
}

public void setHeader(String name, String value) {
   delegate.setHeader(name, value);
   internalSetHeader(name, value);
}


public void setIntHeader(String name, int value) {
   delegate.setIntHeader(name, value);
   internalSetHeader(name, new Integer(value));
}


public void setDateHeader(String name, long date) {
   delegate.setDateHeader(name, date);
   internalSetHeader(name, new Long(date));
}

public void sendError(int sc, String msg) throws IOException {
   delegate.sendError(sc, msg);
    didError = true;
}


public void sendError (int sc) throws IOException {
          delegate.sendError (sc);
           didError = true;

}   

public void sendRedirect(String location) throws IOException {
   delegate.sendRedirect(location);
    didRedirect = true;
}

public String encodeURL(String url) {
   return delegate.encodeURL(url);
}

public String encodeRedirectURL(String url) {
   return delegate.encodeRedirectURL(url);
}

public void addHeader(String name, String value) {
   internalAddHeader(name, value);
}


public void addIntHeader(String name, int value) {
   internalAddHeader(name, new Integer(value));
}

public void addDateHeader(String name, long value) {
   internalAddHeader(name, new Long(value));
}

/**@deprected*/
public String encodeUrl(String url) {
   return this.encodeURL(url);
}

/**@deprected*/
public String encodeRedirectUrl(String url) {
   return this.encodeRedirectURL(url);
 }
}

class CacheServletOutputStream extends ServletOutputStream {
   ServletOutputStream delegate;
   ByteArrayOutputStream cache;

 CacheServletOutputStream(ServletOutputStream out) {
    delegate = out;
    cache = new ByteArrayOutputStream(4096);
 }

 public ByteArrayOutputStream getBuffer() {
   return cache;
}

 public void write(int b) throws IOException {
   delegate.write(b);
   cache.write(b);
 }

 public void write(byte b[]) throws IOException {
   delegate.write(b);
   cache.write(b);
 }

 public void write(byte buf[], int offset, int len) throws IOException {
   delegate.write(buf, offset, len);
   cache.write(buf, offset, len);
 }
}
