import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import org.w3c.dom.*;
import org.w3c.dom.html.*;

import org.enhydra.xml.io.DOMFormatter;

public class ToolViewServlet extends HttpServlet {

  private Tool[] tools;

  public void init() throws ServletException {
    // Zaadowanie danych narzdzi w init w celu uproszczenia
    String toolsFile = getInitParameter("toolsFile"); // z web.xml
    if (toolsFile == null) {
      throw new ServletException(        
        "Plik danych narzdzi musi by okrelony jako parametr inicjalizacji toolsFile");
    }
    log("adowanie narzdzi z " + toolsFile);
    try {
      tools = Tool.loadTools(toolsFile);
      if (tools.length == 0) {
        log("Nie odnaleziono narzdzi w " + toolsFile);
      }
      else {
        log(tools.length + " narzdzia znaleziono w " + toolsFile);
      }
    }
    catch (Exception e) {
      throw new ServletException(e);
    }
  }

  public void doGet(HttpServletRequest req, HttpServletResponse res) 
                               throws ServletException, IOException {
    res.setContentType("text/html");
    PrintWriter out = res.getWriter();
    
    // Utworzenie drzewa DOM dla penego dokumentu
    Template template = new Template();

    // Utworzenie drzewa DOM przechowujcego wewntrzn zawarto    
    ToolView toolview = new ToolView();
    
    // Pobranie prototypowego rekordu narzdzia
    HTMLDivElement record = toolview.getElementRecord();
    
    // Pobranie referencji do punktu wstawiania  dla listy narzdzi
    HTMLDivElement insertionPoint = template.getElementContent();
    Node insertionParent = insertionPoint.getParentNode();

    
    // Ustawienie tytuw i opisu szablonu
    // Pobranie danych z pliku toolview.html
    String title = ((Text)toolview.getElementTitle().getFirstChild()).getData();
    String deck = ((Text)toolview.getElementDeck().getFirstChild()).getData();
    String desc = ((Text)toolview.getElementDesc().getFirstChild()).getData();
    template.setTitle(title);     // tytu strony
    template.setTextTitle(title); // element oznaczony "title"
    template.setTextDeck(deck);   // element oznaczony "deck"
    template.setTextDesc(desc);   // element oznaczony "desc"
    
    // Ptla na narzdziach, dodanie nowego rekordu dla kadego
    for (int i = 0; i < tools.length; i++) {
      Tool tool = tools[i];

      toolview.setTextToolName(tool.name);
      toolview.setTextToolComments(tool.comments);

      if (tool.isNewWithin(45)) {
        toolview.setTextToolStatus(" (Nowo!) ");
      }
      else if (tool.isUpdatedWithin(45)) {
        toolview.setTextToolStatus(" (Uaktualnienie!) ");
      }
      else {
        toolview.setTextToolStatus("");
      }

      HTMLAnchorElement link = toolview.getElementToolLink();
      link.setHref(tool.homeURL);
      Text linkText = toolview.createTextNode(tool.homeURL);
      link.replaceChild(linkText, link.getLastChild());
      
      // importNode() do DOM Level 2
      insertionParent.insertBefore(template.importNode(record, true), null);
    }
    
    // Usunicie obszaru zablokowanego
    insertionParent.removeChild(insertionPoint);
        
    // Wywietlenie dokumentu
    DOMFormatter formatter = new DOMFormatter();  // moe by poprawiony
    formatter.write(template, out);
  }
}
