package com.oreilly.servlet;

import java.io.*;
import java.net.*;
import java.util.*;

public class HttpMessage {

  URL servlet = null;
  Hashtable headers = null;

  public HttpMessage(URL servlet) {
    this.servlet = servlet;
  }

  public InputStream sendGetMessage() throws IOException {
    return sendGetMessage(null);
  }

  public InputStream sendGetMessage(Properties args) throws IOException {
    String argString = "";  // domylny

    if (args != null) {
      argString = "?" + toEncodedString(args);
    }
    URL url = new URL(servlet.toExternalForm() + argString); 

    // Wyczenie buforowania
    URLConnection con = url.openConnection();
    con.setUseCaches(false);

    // Wysyanie nagwkw
    sendHeaders(con);

    return con.getInputStream();
  }

  public InputStream sendPostMessage() throws IOException {
    return sendPostMessage(null);
  }

  public InputStream sendPostMessage(Properties args) throws IOException {
    String argString = "";  // domylny
    if (args != null) {
      argString = toEncodedString(args);
    }

    URLConnection con = servlet.openConnection();

    // Przygotowanie do wysyania i odbierania
    con.setDoInput(true);
    con.setDoOutput(true);

    // Wyczenie buforowania
    con.setUseCaches(false);

    // Ominicie bdu w Netscape'ie
    con.setRequestProperty("Content-Type",
                           "application/x-www-form-urlencoded");

    // Wysanie nagwkw
    sendHeaders(con);

    // Zapisanie argumentw jako danych wysyanych
    DataOutputStream out = new DataOutputStream(con.getOutputStream());
    out.writeBytes(argString);
    out.flush();
    out.close();

    return con.getInputStream();
  }

  public InputStream sendPostMessage(Serializable obj) throws IOException {
    URLConnection con = servlet.openConnection();

    // Przygotowanie do wysyania i odbierania
    con.setDoInput(true);
    con.setDoOutput(true);

    // Wyczenie buforowania
    con.setUseCaches(false);

    // Ustawienie typu zawartoci na application/x-java-serialized-object
    con.setRequestProperty("Content-Type",
                           "application/x-java-serialized-object");

    // Wysanie nagwkw
    sendHeaders(con);

    // Zapisanie argumentw jako danych wysyanych
    ObjectOutputStream out = new ObjectOutputStream(con.getOutputStream());
    out.writeObject(obj);
    out.flush();
    out.close();

    return con.getInputStream();
  }

  public void setHeader(String name, String value) {
    if (headers == null) {
      headers = new Hashtable();
    }
    headers.put(name, value);
  }

  // Wysanie zawartoci tablicy asocjacyjnej nagwkw do serwera
  private void sendHeaders(URLConnection con) {
    if (headers != null) {
      Enumeration enum = headers.keys();
      while (enum.hasMoreElements()) {
        String name = (String) enum.nextElement();
        String value = (String) headers.get(name);
        con.setRequestProperty(name, value);
      }
    }
  }

  public void setCookie(String name, String value) {
    if (headers == null) {
      headers = new Hashtable();
    }
    String existingCookies = (String) headers.get("Cookie");
    if (existingCookies == null) {
      setHeader("Cookie", name + "=" + value);
    }
    else {
      setHeader("Cookie", existingCookies + "; " + name + "=" + value);
    }
  }

  public void setAuthorization(String name, String password) {
    String authorization = Base64Encoder.encode(name + ":" + password);
    setHeader("Authorization", "Basic " + authorization);
  }

  private String toEncodedString(Properties args) {
    StringBuffer buf = new StringBuffer();
    Enumeration names = args.propertyNames();
    while (names.hasMoreElements()) {
      String name = (String) names.nextElement();
      String value = args.getProperty(name);
      buf.append(URLEncoder.encode(name) + "=" + URLEncoder.encode(value));
      if (names.hasMoreElements()) buf.append("&");
    }
    return buf.toString();
  }
}
