import java.io. *;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oreilly.servlet.ServletUtils;

public class ViewFile extends HttpServlet {

   public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
      // Uyj ServletOutputStream poniewa moemy przekaza informacj
      // binarn
      ServletOutputStream out = res.getOutputStream() ;

      // Pobierz plik do przegldania
      String file = req.getPathTranslated();

      // Plik nie istnieje, przegldanie niemoliwe do realizacji
      if (file == null) {
         out.println("Nie mona przeglda pliku");
         return;
      }

      // pobierz i ustal typ pliku
      String contentType = getServletContext().getMimeType(file);
      res.setContentType(contentType) ;

      // zwr plik
      try {
         ServletUtils.returnFile(file, out);
      }
      catch (FileNotFoundException e) {
         out.println("Pliku nie odnaleziono") ;
      }
      catch (IOException e) {
         out.println("Problem z przesaniem pliku: " + e.getMessage());
   }
  }
 }
