import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import org.w3c.dom.*;
import org.w3c.dom.html.*;

import org.enhydra.xml.io.DOMFormatter;

public class SnoopManipulation extends HttpServlet {

  public void doGet(HttpServletRequest req, HttpServletResponse res) 
                               throws ServletException, IOException {
    res.setContentType("text/html");
    PrintWriter out = res.getWriter();
    
    // Pobranie do wywietlenia pewnych danych dynamicznych
    Enumeration locales = req.getLocales();
    
    // Utworzenie drzewa DOM
    Snoop snoop = new Snoop();
    
    // Pobranie pierwszego, "prototypowego" elementu listy
    // Reszta zostaa usunita podczas kompilacji xmlc
    HTMLLIElement item = snoop.getElementLocale();
    
    // Pobranie rodzica prototypu w celu umoliwienia zarzdzania potomkami
    Node parent = item.getParentNode();

    // Ptla na lokalizacjach i dodanie wza dla kadej
    while (locales.hasMoreElements()) {
      Locale loc = (Locale)locales.nextElement();
      HTMLLIElement newItem = (HTMLLIElement) item.cloneNode(true);
      Text text = snoop.createTextNode(loc.toString());
      newItem.replaceChild(text, newItem.getLastChild());
      parent.insertBefore(newItem, null);
    }
    
    // Usunicie elementu prototypowego
    parent.removeChild(item);
    
    // Wywietlenie dokumentu
    DOMFormatter formatter = new DOMFormatter();  // moe by poprawiony
    formatter.write(snoop, out);
  }
}
