import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oreilly.servlet.RemoteDaemonHttpServlet;

public class DaytimeServlet extends RemoteDaemonHttpServlet
             implements DaytimeServer {

  public Date getDate() {
    return new Date();
  }

  public void init() throws ServletException {
    // Jak poprzednio, nie ma potrzeby wywoywania super.init()
    // z bezargumentowej metody init, trzeba jednak wywoa super.init(config) ze 
    // starszej metody init(ServletConfig). Szczegy mona znale w rozdziale 3.
  }

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
    // Jeeli klient przesa "format=object", 
    // to wysanie daty jako obiektu zserializowanego
    if ("object".equals(req.getParameter("format"))) {
      ObjectOutputStream out = new ObjectOutputStream(res.getOutputStream());
      out.writeObject(getDate());
    }
    // W przeciwnym wypadku wysanie daty jako zwykego acucha ASCII
    else {
      PrintWriter out = res.getWriter();
      out.println(getDate().toString());
    }
  }

  public void doPost(HttpServletRequest req, HttpServletResponse res)
                                throws ServletException, IOException {
    doGet(req, res);
  }

  public void destroy() {
    // W tym miejscu, inaczej ni poprzednio, po nadpisaniu destroy()
    // naley wywoa super.destroy()
    super.destroy();
  }

  // Obsuga gniazd klienta poprzez dodanie 
  // wtku DaytimeConnection
  public void handleClient(Socket client) {
    new DaytimeConnection(this, client).start();
  }
}

class DaytimeConnection extends Thread {

  DaytimeServlet servlet;
  Socket client;

  DaytimeConnection(DaytimeServlet servlet, Socket client) {
    this.servlet = servlet;
    this.client = client;
    setPriority(NORM_PRIORITY - 1);
  }

  public void run() {
    try {
      // Odczytanie pierwszej linii wysanej przez klienta,
      // jako tekstu Latin-2
      BufferedReader in = new BufferedReader(
                          new InputStreamReader(
                          client.getInputStream(), "ISO-8859-2"));
      String line = in.readLine();

      // Jeeli brzmiaa ona object, zwrcenie Date jako 
      // obiektu zserializowanego
      if ("object".equals(line)) {
        ObjectOutputStream out =
          new ObjectOutputStream(client.getOutputStream());
        out.writeObject(servlet.getDate());
        out.close();
      }
      // W przeciwnym wypadku wysanie Data jako zwykego acucha
      else {
        // Opakowanie strumienia OutputStream obiektu klasy Socket
        // klas PrintStream
        PrintStream out = new PrintStream(client.getOutputStream());
        out.println(servlet.getDate().toString());
        out.close();
      }

      // Naley zapewni zamknicie poczenia
      client.close();
    }
    catch (IOException e) {
      servlet.log("Wyjtek typu IOException podczas obsugi dania klienta", e);
    }
    catch (Exception e) {
      servlet.log("Wyjtek typu Exception podczas obsugi dania klienta", e);
    }
  }
}
