import java.applet.*;
import java.awt.*;
import java.io.*;
import java.util.*;

public class DaytimeApplet extends Applet {

  TextField httpText, httpObject, socketText, socketObject, RMIObject;
  Button refresh;

  public void init() {
    // Konstruowanie interfejsu uytkownika

    setLayout(new BorderLayout());

    // Po lewej stronie dodanie etykiet dla rnych mechanizmw komunikacji
    Panel west = new Panel();
    west.setLayout(new GridLayout(5, 1));
    west.add(new Label("Tekst HTTP: ", Label.RIGHT));
    west.add(new Label("Obiekt HTTP: ", Label.RIGHT));
    west.add(new Label("Tekst gniazda: ", Label.RIGHT));
    west.add(new Label("Obiekt gniazda: ", Label.RIGHT));
    west.add(new Label("Obiekt RMI: ", Label.RIGHT));
    add("West", west);

    // Po prawej utworzenie pl tekstowych wywietlajcych otrzymane wartoci czasu
    Panel center = new Panel();
    center.setLayout(new GridLayout(5, 1));

    httpText = new TextField();
    httpText.setEditable(false);
    center.add(httpText);

    httpObject = new TextField();
    httpObject.setEditable(false);
    center.add(httpObject);

    socketText = new TextField();
    socketText.setEditable(false);
    center.add(socketText);

    socketObject = new TextField();
    socketObject.setEditable(false);
    center.add(socketObject);

    RMIObject = new TextField();
    RMIObject.setEditable(false);
    center.add(RMIObject);

    add("Center", center);

    // Na dole utworzenie przycisku uaktualniajcego czas
    Panel south = new Panel();
    refresh = new Button("Odswie");
    south.add(refresh);
    add("South", south);
  }

  public void start() {
    refresh();
  }

  private void refresh() {
    // pobranie i wywietlenie wartoci czasu
    httpText.setText(getDateUsingHttpText());
    httpObject.setText(getDateUsingHttpObject());
    socketText.setText(getDateUsingSocketText());
    socketObject.setText(getDateUsingSocketObject());
    RMIObject.setText(getDateUsingRMIObject());
  }

  private String getDateUsingHttpText() {
    // Pobranie obecnego czasu za pomoc poczenia 
    // HTTP opartego na tekcie
    return "niedostpny";
  }

  private String getDateUsingHttpObject() {
    // Pobranie obecnego czasu za pomoc poczenia 
    // HTTP opartego na obiekcie
    return "niedostpny";
  }

  private String getDateUsingSocketText() {
    // Pobranie obecnego czasu za pomoc poczenia 
    // innego ni HTTP opartego na tekcie
    return "niedostpny";
  }

  private String getDateUsingSocketObject() {
    // Pobranie obecnego czasu za pomoc poczenia 
    // innego ni HTTP opartego na obiekcie
    return "niedostpny";
  }

  private String getDateUsingRMIObject() {
    // Pobranie obecnego czasu przy pomocy komunikacji RMI
    return "niedostpny";
  }

  public boolean handleEvent(Event event) {
    // Po przyciniciu przycisku "Odwie" odwieenie ekranu
    // Wykorzystanie zdarze JDK 1.0 w celu zapewnienia maksymalnej przenonoci
    switch (event.id) {
      case Event.ACTION_EVENT:
        if (event.target == refresh) {
          refresh();
          return true;
        }
    }
    return false;
  }
}
