import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ChatDispatch extends HttpServlet { 

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws IOException, ServletException {
    res.setContentType("text/html; charset=ISO-8859-2");

    if (!req.getParameterNames().hasMoreElements()) {
      // Nie byo parametrw dania. Wywietlenie strony powitalnej.
      printWelcomePage(req, res);
    }
    else {
      // Wystapi przynajmniej jeden parametr dania.
      // Wywietl stron apletu.
      printAppletPage(req, res);
    }
  }

  // Strona powitalna wita uytkownika i wywietla formularz, w ktrym uytkownik moe 
  // wybra metod komunikacji aplet-serwlet
  private void printWelcomePage(HttpServletRequest req,
                                HttpServletResponse res)
                    throws IOException {
    PrintWriter out = res.getWriter();
    String me = req.getServletPath();

    out.println("<HTML>");
    out.println("<HEAD><TITLE>");
    out.println("Witamy w absurdalnie prostym chacie");
    out.println("</TITLE></HEAD>");
    out.println();
    out.println("<BODY>");
    out.println("<H1> Witamy w absurdalnie prostym chacie </H1>");
    out.println();
    out.println("Prosz wybra form komunikacji:");
    out.println("<UL>");
    out.println("  <LI><A HREF=\"" + me + "?method=http\">http</A>");
    out.println("  <LI><A HREF=\"" + me + "?method=socket\">socket</A>");
    out.println("  <LI><A HREF=\"" + me + "?method=rmi\">rmi</A>");
    out.println("</UL>");
    out.println("</BODY></HTML>");
  }

  // Strona apletu wywietla aplet pogawdek.
  private void printAppletPage(HttpServletRequest req,
                               HttpServletResponse res)
                    throws IOException {
    PrintWriter out = res.getWriter();

    out.println("<HTML>");
    out.println("<HEAD><TITLE>Absurdalnie prosty chat</TITLE></HEAD>");
    out.println("<BODY>");
    out.println("<H1>Absurdalnie prosty chat</H1>");

    String method = req.getParameter("method");
    String user = req.getRemoteUser();
    String applet = null;

    if ("http".equals(method)) {
      applet = "HttpChatApplet";
    }
    else if ("socket".equals(method)) {
      applet = "SocketChatApplet";
    }
    else if ("rmi".equals(method)) {
      applet = "RMIChatApplet";
    }
    else {
      // Brak podanej metody lub metoda nieprawidowa.
      // outanienie uytkownikowi oczekiwa.
      out.println("Przepraszamy, ten serwlet potrzebuje parametru <TT>method</TT> " + 
                  "o jednej z poniszych wartoci: " + 
                  "http, socket, rmi"); 
      return;
    }

    // Wywietlenie kodu HTML w celu wygenerowania apletu.
    // Wybranie kodu apletu opartego na parametrze method.
    // Dostarczenie parametru user, jeeli uytkownik jest znany.
    out.println("<APPLET CODE=" + applet + " CODEBASE=/ " +
                "WIDTH=500 HEIGHT=170>");
    if (user != null)
      out.println("<PARAM NAME=user VALUE=\"" + user + "\">");
    out.println("</APPLET>");

    out.println("</BODY></HTML>");
  }
}
