import java.sql.*;

public class HtmlResultSet {
   private ResultSet rs;

   public HtmlResultSet(ResultSet rs) {
      this.rs = rs;
   }

   public String toString() {  // moe by wywoana tylko raz
      StringBuffer out = new StringBuffer();
      // Zaczynamy tworzy tabel aby wywietli zestaw wynikw
      out.append("<TABLE>\n");

      try {
         ResultSetMetaData rsmd = rs.getMetaData();

         int numcols = rsmd.getColumnCount();

         // Tytu tabeli z etykietami kolumn zestaww wynikw
         out.append("<TR>");
         for (int i = 1; i <= numcols; i++) {
          out.append("<TH>" + rsmd.getColumnLabel(i));  
         }
         out.append("</TR>\n");

         while (rs.next()) {
            out.append("<TR>");  // tworzymy nowy wiersz
            for (int i = 1; i <= numcols; i++) {
               out.append("<TD>");   // tworzymy nowy element danych
                  Object obj = rs.getObject(i);
                  if (obj != null)
                     out.append(obj.toString());
                        else
                     out.append("&nbsp;");
               }
                out.append("</TR>\n"); 
         }

         // Koniec tabeli
         out.append("</TABLE>\n");
      }
      catch (SQLException e) {
         out.append("</TABLE><H1>BD:</H1> " + e.getMessage() + "\n");
      }

      return out.toString();
   }
}
