import java.awt.* ;
import java.awt.image.*;

public class GrayscaleImageFilter extends RGBImageFilter {

   public GrayscaleImageFilter() {
      canFilterIndexColorModel = true;
   }

   // Konwertuj kolorowe piksele na czarno-biae
   // Algorytm jest zgodny ze specyfikacj NTSC
   public int filterRGB(int x, int y, int pixel) {

   // Pobierz rednie natenie RGB
   int red = (pixel & 0x00ff0000) >> 16;
   int green = (pixel & 0x0000ff00) >> 8;
   int blue = pixel & 0x000000ff;

   int luma = (int) (0.299 * red + 0.587 * green + 0.114 * blue);

   // Zwr warto luma dla kadego komponentu RGB
   // Uwaga: Alfa (przezroczysto) jest zawsze ustawiana na warto maksymaln (nie przezroczyst)
   return (0xff << 24) | (luma << 16) | (luma << 8) | luma;
  }
}
