﻿// map.js
(function () {
  "use strict";

  function createMap(options) {
    options = options || {};
    options.credentials = options.credentials || "TODO"; // Tutaj jest twój identyfikator Bing API
    options.center = options.center || new Microsoft.Maps.Location(50.2925846, 18.6697257);
    options.zoom = options.zoom || 10;

    new Microsoft.Maps.Map(map, options);
  }

  function getMessage(e) {
    // dobrze sprawdź pochodzenie komunikatu
    if (e.origin === "ms-appx://" + document.location.host) {
      // odtwórz mapę z nowymi współrzędnymi
      var geocode = JSON.parse(e.data);
      createMap({ center: new Microsoft.Maps.Location(geocode.lat, geocode.long) });
    }
  }

  document.addEventListener("DOMContentLoaded", createMap);
  window.addEventListener("message", getMessage);
})();
