﻿// Poniższa dokumentacja zawiera wprowadzenie do szablonu Blank:
// http://go.microsoft.com/fwlink/?LinkId=232509
(function () {
    "use strict";
  
    var locator, map;
    var app = WinJS.Application;
    var activation = Windows.ApplicationModel.Activation;
    WinJS.strictProcessing();

    function requestNavigatorPosition() {
      window.navigator.geolocation.getCurrentPosition(successCallback, errorCallback);

      //var watchId = navigator.geolocation.watchPosition(successCallback, errorCallback);
    }

    //document.getElementById('clear').addEventListener('click', function () {
    //  navigator.geolocation.clearWatch(watchId);
    //});

    function successCallback(position) {
      document.getElementById("latitude").innerHTML = position.coords.latitude;
      document.getElementById("longitude").innerHTML = position.coords.longitude;
      document.getElementById("accuracy").innerHTML = position.coords.accuracy;

      addToMap(position.coords.latitude, position.coords.longitude);
    }

    function addToMap(lat, long) {
      map.setView({
        center: new Microsoft.Maps.Location(lat, long),
        mapTypeId: Microsoft.Maps.MapTypeId.auto, zoom: 18
      });

      var pushpin = new Microsoft.Maps.Pushpin(map.getCenter(), null);
      map.entities.push(pushpin);
      //map.entities.push(new Microsoft.Maps.Infobox(map.getCenter(), { title: 'Here', description: 'You are here!', pushpin: pushpin }));
    }

    function errorCallback(error) {
      var strMessage = "";
      
      // Check for known errors
      switch (error.code) {
        case error.PERMISSION_DENIED:
          strMessage = "Dostęp do usługi lokalizacyjnej jest wyłączony. " +
              "Zmień ustawienia, aby ją włączyć.";
          break;
        case error.POSITION_UNAVAILABLE:
          strMessage = "Dane z usługi lokalizacyjnej " +
              "są obecnie niedostępne.";
          break;
        case error.TIMEOUT:
          strMessage = "Lokalizacja nie mogła być określona " +
              "w zadanym okresie czasu.";
          break;
        default:
          break;
      }

      document.getElementById("status").innerHTML = strMessage;
    }
    
    function requestWinPosition() {
      locator = new Windows.Devices.Geolocation.Geolocator();
      locator.getGeopositionAsync().done(getPositionHandler, errorHandler);

      //locator.addEventListener('positionchanged', getPositionHandler);
    }

    function getPositionHandler(location) {
      document.getElementById("latitude").innerHTML = location.coordinate.latitude;
      document.getElementById("longitude").innerHTML = location.coordinate.longitude;
      document.getElementById("accuracy").innerHTML = location.coordinate.accuracy;
      document.getElementById("status").innerHTML = getStatusString(locator.locationStatus);
      
      addToMap(location.coordinate.latitude, location.coordinate.longitude);
    }

    function errorHandler(err) {
      document.getElementById("status").innerHTML = getStatusString(locator.locationStatus);
    }

    function getStatusString(locStatus) {
      switch (locStatus) {
        case Windows.Devices.Geolocation.PositionStatus.ready:
          return "Lokalizacja dostępna.";
          break;
        case Windows.Devices.Geolocation.PositionStatus.initializing:
          return "Urządzenie GPS w trakcie inicjalizacji.";
          break;
        case Windows.Devices.Geolocation.PositionStatus.noData:
          return "Dane z usług lokalizacyjnych niedostępne.";
          break;
        case Windows.Devices.Geolocation.PositionStatus.disabled:
            return "Usługa lokalizacyjna jest wyłączona." +
              "Zmień ustawienia w pasku ustawień" +
              " aby ją ponownie włączyć.";
          break;
        case Windows.Devices.Geolocation.PositionStatus.notInitialized:
          return "Status lokalizacji nie jest zainicjowany, " +
              "ponieważ aplikacja nie zażądała danych lokalizacyjnych.";
          break;
        case Windows.Devices.Geolocation.PositionStatus.notAvailable:
          return "Brak w systemie żądanej usługi lokalizacyjnej.";
          break;
        default:
          break;
      }
    }

   function initMap() {
      try {
        var mapOptions =
        {
          credentials: "Aobl4homd3pxwBrWnQNuX25Vna6u25EHc-LJcvzIGPldJLQZdsGq6mk57Aq0ft80",
          center: new Microsoft.Maps.Location(50.288825, 18.6595556),
          mapTypeId: Microsoft.Maps.MapTypeId.auto,
          zoom: 17
        };
        map = new Microsoft.Maps.Map(document.getElementById("map"), mapOptions);
      }
      catch (e) {
        var md = new Windows.UI.Popups.MessageDialog(e.message);
        md.showAsync();
      }
    }


    app.onactivated = function (args) {
        if (args.detail.kind === activation.ActivationKind.launch) {
          args.setPromise(WinJS.UI.processAll().done(function() {
            document.querySelector('#HTML5Loc').addEventListener('click', requestNavigatorPosition);
            document.querySelector('#WinLoc').addEventListener('click', requestWinPosition);

            Microsoft.Maps.loadModule('Microsoft.Maps.Map', { callback: initMap });

          }));
        }
    };

    app.start();
})();
