﻿(function () {
  "use strict";

  var appViewState = Windows.UI.ViewManagement.ApplicationViewState;
  var ui = WinJS.UI;

  ui.Pages.define("/pages/items/items.html", {

    // Ta funkcja aktualizuje nowy układ obiektu ListView
    initializeLayout: function (listView, viewState) {
      /// <param name="listView" value="WinJS.UI.ListView.prototype" />

      if (viewState === appViewState.snapped) {
        listView.layout = new ui.ListLayout();
      } else {
        listView.layout = new ui.GridLayout();
      }
    },

    itemInvoked: function (args) {
      var groupKey = Data.groups.getAt(args.detail.itemIndex).key;
      WinJS.Navigation.navigate("/pages/split/split.html", { groupKey: groupKey });
    },

    // Ta funkcja jest wywoływana, gdy użytkownik otworzy tę stronę.
    // Umieszcza dane aplikacyjne w elementach strony.
    ready: function (element, options) {
      var listView = element.querySelector(".itemslist").winControl;
      listView.itemDataSource = Data.groups.dataSource;
      listView.itemTemplate = element.querySelector(".itemtemplate");
      listView.oniteminvoked = this.itemInvoked.bind(this);

      this.initializeLayout(listView, Windows.UI.ViewManagement.ApplicationView.value);
      listView.element.focus();

      // Zdefiniuj przycisk włączający zadania w tle
      var button = element.querySelector("#enableTimerButton");
      button.addEventListener("click", function (e) {
        this.enableTimerTask();
      }.bind(this));
    },

    enableTimerTask: function () {
      var background = Windows.ApplicationModel.Background;
      
      // Określ nazwę zadania
      // (używana do upewnienia się, że zarejestrowaliżmy tylko jedno zadanie)
      var taskName = "Zadanie czasomierza RSS Reader";

      // Pobierz listę zadań w tle
      var tasks = background.BackgroundTaskRegistration.allTasks;

      // Poszukaj zadania
      var found = false;
      var iter = tasks.first();
      var hasValue = iter.hasCurrent;
      while (hasValue) {
        var task = iter.current.value;
        if (task.name == taskName) {
          found = true;
          break;
        }
        // Sprawdź następne
        hasValue = iter.moveNext();
      };

      // Dodaj tylko wtedy, gdy nie można go znaleźć
      if (!found) {
        // utwórz zadanie
        var taskBuilder = new background.BackgroundTaskBuilder();
        taskBuilder.name = taskName;
        taskBuilder.taskEntryPoint = "js\\backgroundtask.js";

        // ustaw wyzwalacz
        // 15 minut, ale może być 15 minut później, z powtarzaniem
        var trigger = new background.TimeTrigger(15, false); // 15 is minimum
        //var triggerType = background.SystemTriggerType.timeZoneChange;
        //var trigger = new background.SystemTrigger(triggerType, false);
        taskBuilder.setTrigger(trigger);

        // ustaw warunek: musi być dostępny internet
        //var type = background.SystemConditionType.internetAvailable;
        //var condition = new background.SystemCondition(type);
        //taskBuilder.addCondition(condition);

        // zarejestruj zadanie
        var result = taskBuilder.register();
        if (result) {
          var dlg = new Windows.UI.Popups.MessageDialog("Dodane");
          dlg.showAsync();
        }
      } else {
        var dlg = new Windows.UI.Popups.MessageDialog("Już zarejestrowane...");
        dlg.showAsync();
      }

    },

    // Ta funkcja aktualizuje układ strony w odpowiedzi na zmiany w viewState.
    updateLayout: function (element, viewState, lastViewState) {
      /// <param name="element" domElement="true" />
      /// <param name="viewState" value="Windows.UI.ViewManagement.ApplicationViewState" />
      /// <param name="lastViewState" value="Windows.UI.ViewManagement.ApplicationViewState" />

      var listView = element.querySelector(".itemslist").winControl;
      if (lastViewState !== viewState) {
        if (lastViewState === appViewState.snapped || viewState === appViewState.snapped) {
          var handler = function (e) {
            listView.removeEventListener("contentanimating", handler, false);
            e.preventDefault();
          }
          listView.addEventListener("contentanimating", handler, false);
          var firstVisible = listView.indexOfFirstVisible;
          this.initializeLayout(listView, viewState);
          listView.indexOfFirstVisible = firstVisible;
        }
      }
    }
  });
})();
