﻿// default.js
// Poniższa dokumentacja zawiera wprowadzenie do szablonu Split:
// http://go.microsoft.com/fwlink/?LinkID=232447
(function () {
  "use strict";

  var app = WinJS.Application;
  var activation = Windows.ApplicationModel.Activation;
  var nav = WinJS.Navigation;
  WinJS.strictProcessing();

  app.addEventListener("activated", function (args) {
    if (args.detail.kind === activation.ActivationKind.launch) {
      if (args.detail.previousExecutionState !== activation.ApplicationExecutionState.terminated) {
        // Do zrobienia: Aplikacja została dopiero uruchomiona.
        // Zainicjuj ją tutaj.
      } else {
        // Do zrobienia: Aplikacja zostałą wznowiona po wstrzymaniu.
        // Odtwórz tutaj stan aplikacji.
      }

      // sprawdź, czy parametry wywołania pochodzą z powiadomienia
      if (args.detail.arguments) {
        var fromToast = JSON.parse(args.detail.arguments);
        var reason = fromToast.reason;
      }

      if (app.sessionState.history) {
        nav.history = app.sessionState.history;
      }

      // Przetwarzaj dane przy uruchomieniu aplikacji
      Data.processAll(function (count) {
        var c = count;
      });

      args.setPromise(WinJS.UI.processAll().then(function () {
        if (nav.location) {
          nav.history.current.initialPlaceholder = true;
          return nav.navigate(nav.location, nav.state);
        } else {
          return nav.navigate(Application.navigator.home);
        }
      }));
    }
  });


  app.oncheckpoint = function (args) {
    // Do zrobienia: Aplikacja będzie wstrzymana. Tutaj zapisz stan, który
    // musi być przetrwać wstrzymanie. Jeżeli jakaś operacja asynchroniczna
    // musi być zakończona przed wstrzymaniem aplikacji, wywołaj args.setPromise().
    app.sessionState.history = nav.history;
  };

  app.onsettings = function (e) {
    e.detail.applicationcommands = {
      feedsFlyout: { title: "Kanały", href: "/settings/feeds/feeds.html" },
      aboutFlyout: { title: "O aplikacji", href: "/settings/about/about.html" },
    };

    WinJS.UI.SettingsFlyout.populateSettings(e);
  };

  app.start();
})();
