﻿(function () {
    "use strict";

    function copyNew() {
        var fileSavePicker = new Windows.Storage.Pickers.FileSavePicker();
        fileSavePicker.suggestedStartLocation = Windows.Storage.Pickers.PickerLocationId.picturesLibrary;
        fileSavePicker.fileTypeChoices.insert("JPEG Image", [".jpeg", ".jpg"]);
        fileSavePicker.defaultFileExtension = ".jpg";
        fileSavePicker.suggestedFileName = "MyCopy";

        fileSavePicker.pickSaveFileAsync().then(function (file) {
            if (file) {
                //funkcja lokalna (pominięta) kopiująca zawartość istniejącego pliku do nowego pliku
                //copyFile(oldfile, file);
            }
        });
    }

    function pickImage() {
        var targetImage = document.querySelector('img#targetMedia');
    	
        targetImage.addEventListener('load', function () {
            WinJS.UI.Animation.fadeIn(this);
        });

        var picker = new Windows.Storage.Pickers.FileOpenPicker();
        picker.viewMode = Windows.Storage.Pickers.PickerViewMode.thumbnail;
        picker.suggestedStartLocation = Windows.Storage.Pickers.PickerLocationId.picturesLibrary;
        picker.fileTypeFilter.replaceAll([".png", ".jpg", ".jpeg", ".tiff", ".gif"]);

        picker.pickSingleFileAsync().then(function (file) {
            if (file) {
                var objUrl = window.URL.createObjectURL(file);
                targetImage.src = objUrl;
            }
        });
    }
    
    function ready(element, options) {
        var pick = document.querySelector('#pickImage');
    	
        pick.addEventListener('click', pickImage);

        var copy = document.querySelector('#copy');
        copy.addEventListener('click', copyNew);
    }

    WinJS.UI.Pages.define("/pages/simpleImagePicker/simpleImagePicker.html", {
        // Ta funkcja jest wywoływana, gdy użytkownik przechodzi do tej strony. To
        // wypełnia elementy strona danymi aplikacji.
        ready: ready
    });
})();
