﻿// home.js
(function () {
    "use strict";

    WinJS.UI.Pages.define("/pages/home/home.html", {
        ready: function (element, options) {
            var people = [
              // powiadom nasłuchujące bindowania, kiedy obiekty ulegną zmianie
              WinJS.Binding.as({ name: "Jasiek", age: 18, favoriteColor: "czerwony" }),
              WinJS.Binding.as({ name: "Tomek", age: 16, favoriteColor: "zielony" }),
              WinJS.Binding.as({ name: "Krzysiek", age: 42, favoriteColor: "niebieski" }),
            ];

            // binduj aktualną osobę do elementu HTML w sekcji
            var section = element.querySelector("section[role=main]");
            var current = 0;
            WinJS.Binding.processAll(section, people[current]);

            birthdayButton.onclick = function () {
                var person = people[current];
                person.age++; // już działa!
            };

            // bindowanie do poprzedniego obiektu
            previousButton.onclick = function () {
                current = (people.length + current - 1) % people.length;
                viewModel.person = people[current];
            };

            // bindowanie do kolejnego obiektu
            nextButton.onclick = function () {
                current = (people.length + current + 1) % people.length;
                viewModel.person = people[current];
            };
        }
    });
})();
