﻿(function () {
  var orientationSensor;
  var app = WinJS.Application;
  
  function onDataChanged(e) {
    switch (e.orientation) {
      case Windows.Devices.Sensors.SimpleOrientation.notRotated:
        document.getElementById('txtOrientation').innerHTML = "Nie obrócony";
        break;
      case Windows.Devices.Sensors.SimpleOrientation.rotated90DegreesCounterclockwise:
        document.getElementById('txtOrientation').innerHTML = "Obrócony o 90 st.";
        break;
      case Windows.Devices.Sensors.SimpleOrientation.rotated180DegreesCounterclockwise:
        document.getElementById('txtOrientation').innerHTML = "Obrócony o 180 st.";
        break;
      case Windows.Devices.Sensors.SimpleOrientation.rotated270DegreesCounterclockwise:
        document.getElementById('txtOrientation').innerHTML = "Obrócony o 270 st";
        break;
      case Windows.Devices.Sensors.SimpleOrientation.faceup:
        document.getElementById('txtOrientation').innerHTML = "Przodem do góry";
        break;
      case Windows.Devices.Sensors.SimpleOrientation.facedown:
        document.getElementById('txtOrientation').innerHTML = "Przodem w dół";
        break;
      default:
        document.getElementById('txtOrientation').innerHTML = "Nieokreślone położenie " + e.orientation;
        break;
    }
  }

  app.onactivated = function (eventObject) {
    if (eventObject.detail.kind === Windows.ApplicationModel.Activation.ActivationKind.launch) {

      orientationSensor = Windows.Devices.Sensors.SimpleOrientationSensor.getDefault();

      if (orientationSensor) {
        orientationSensor.addEventListener("orientationchanged", onDataChanged);
      }

      WinJS.UI.processAll();
    }
  };

  app.start();

})();
