﻿// Poniższa dokumentacja zawiera wprowadzenie do szablonu Blank:
// http://go.microsoft.com/fwlink/?LinkId=232509
(function () {
    "use strict";

    var compass;
    var app = WinJS.Application;
    var activation = Windows.ApplicationModel.Activation;
    
    function rotateCompass(heading) {
      var compass = document.querySelector('embed');

      compass.setAttribute('style', "transform: rotate(-" + Math.floor(heading) + "deg);");
    }

    app.onactivated = function (args) {
        if (args.detail.kind === activation.ActivationKind.launch) {
          var compassDataLabel = document.getElementById('compassData');
          var reading;

          compass = Windows.Devices.Sensors.Compass.getDefault();

          if (compass) {
            compass.reportInterval = 50;
            compass.addEventListener("readingchanged", function (event) {
              reading = event.reading;
              var heading = reading.headingMagneticNorth !== null ? reading.headingMagneticNorth.toFixed(2) : reading.headingTrueNorth.toFixed(2);
              compassDataLabel.innerText = heading;

              rotateCompass(heading);
            });

            reading = compass.getCurrentReading();
            compassDataLabel.innerText = reading.headingMagneticNorth || reading.headingTrueNorth;
          }

          args.setPromise(WinJS.UI.processAll());
        }
    };

    app.oncheckpoint = function (args) {
        // Do zrobienia: Aplikacja będzie wstrzymana. Tutaj zapisz stan, który
        // musi być przetrwać wstrzymanie. Jeżeli jakaś operacja asynchroniczna
        // musi być zakończona przed wstrzymaniem aplikacji, wywołaj args.setPromise().
    };

    app.start();
})();
