﻿(function () {
    "use strict";

    var feeds = new WinJS.Binding.List([
      { title: "Brandon Satrom", url: "http://feeds.feedburner.com/userinexperience/tYGT" },
      { title: "Chris Sells", url: "http://sellsbrothers.com/posts/?format=rss" },
      { title: "Wirtualna Polska", url: "http://media.wp.pl/kat,1022955,ver,rss,rss.xml" },
    ]);

    function ready(element, options) {
      // TODO: Zainicjuj tutaj fragment

      // Pokaż kanały
      var section = element.querySelector("section");
      section.innerHTML = "";

      feeds.forEach(function (feed) {
        var div = document.createElement("div");
        div.innerText = feed.title;
        section.appendChild(div);
      });
    }
  
    WinJS.Utilities.markSupportedForProcessing(feedInvoked);
    function feedInvoked(event) {
      if (event) { 
        var f = feeds.getAt(event.detail.itemIndex);
        WinJS.Navigation.navigate("/pages/posts/posts.html", { feed: f });
      }
    }

    WinJS.Namespace.define('Feed', {
      feeds: feeds,
      feedInvoked: feedInvoked
    });

    WinJS.UI.Pages.define("/pages/home/home.html", {
        // Ta funkcja jest wywoływana, gdy użytkownik otworzy tę stronę.
        // Umieszcza dane aplikacyjne w elementach strony.
        ready: function (element, options) {
            // TODO: Zainicjuj tutaj stronę
        }
    });
})();
