﻿(function () {
    "use strict";

    WinJS.UI.Pages.define("/pages/home/home.html", {
        ready: function (element, options) {

            openTextFileButton.onclick = function () {
                // zapytanie użytkownika o plik i odczyt pliku 
                var openPicker = new Windows.Storage.Pickers.FileOpenPicker();
                openPicker.suggestedStartLocation = Windows.Storage.Pickers.PickerLocationId.documentsLibrary;
                openPicker.fileTypeFilter.replaceAll([".txt", ".bat"]);

                openPicker.pickSingleFileAsync().then(function (file) {
                    if (file) {
                        // odczyt z wybranego pliku
                        openStatus.innerText = "Otwarto: " + file.name + " (path= '" + file.path + "')";
                        Windows.Storage.FileIO.readTextAsync(file).done(function (text) {
                            openFileTextArea.value = text;
                        });
                    }
                    else {
                        // użytkownik anulował operację
                        openStatus.innerText = "Otwieranie anulowane";
                        openFileTextArea.value = "";
                    }
                });
            };

            saveTextFileButton.onclick = function () {
                // zapytanie użytkownika o plik i zapis do pliku 
                var savePicker = new Windows.Storage.Pickers.FileSavePicker();
                savePicker.suggestedStartLocation = Windows.Storage.Pickers.PickerLocationId.documentsLibrary;
                savePicker.fileTypeChoices.insert("Plik tekstowy", [".txt"]);
                savePicker.fileTypeChoices.insert("Plik wykonywalny", [".bat"]);
                savePicker.suggestedFileName = "Nowy dokument";

                savePicker.pickSaveFileAsync().then(function (file) {
                    if (file) {
                        // zapis do wybranego pliku
                        Windows.Storage.FileIO.writeTextAsync(file, saveFileTextArea.value).done(function () {
                            // zawartość pliku została zapisana
                            saveStatus.innerText = "Zapisano: " + file.name + " (path= '" + file.path + "')";
                            saveFileTextArea.value = "";
                        });
                    }
                    else {
                        // użytkownik anulował operację
                        saveStatus.innerText = "Zapis anulowany";
                    }
                });
            };

            pickFolderButton.onclick = function () {
                // zapytanie użytkownika o katalog
                var folderPicker = new Windows.Storage.Pickers.FolderPicker;
                folderPicker.suggestedStartLocation = Windows.Storage.Pickers.PickerLocationId.documentsLibrary;
                folderPicker.fileTypeFilter.replaceAll(["*"]);

                folderPicker.pickSingleFolderAsync().then(function (folder) {
                    if (folder) {
                        // wykorzystaj dostęp do zapisu/odczytu do katalogu teraz 
                        // lub zapisz uprawnienia na później:
                        // Windows.Storage.AccessCache.StorageApplicationPermissions.futureAccessList.addOrReplace("PickedFolderToken", folder);
                        pickStatus.innerText = "Picked: " + folder.name + " (path= '" + folder.path + "')";
                    }
                    else {
                        // użytkownik anulował operację
                        pickStatus.innerText = "Wybór anulowany";
                    }
                });
            };

        },
    });
})();
