﻿(function () {
    "use strict";

    var appViewState = Windows.UI.ViewManagement.ApplicationViewState;
    var binding = WinJS.Binding;
    var nav = WinJS.Navigation;
    var ui = WinJS.UI;
    var utils = WinJS.Utilities;

    ui.Pages.define("/pages/split/split.html", {

        /// <field type="WinJS.Binding.List" />
        items: null,
        /// <field type="Object" />
        group: null,
        itemSelectionIndex: -1,

        // Ta funkcja sprawdza, czy lista i kolumny szczegółów powinny być wyświetlane
        // na osobnych stronach zamiast obok siebie.
        isSingleColumn: function () {
            var viewState = Windows.UI.ViewManagement.ApplicationView.value;
            return (viewState === appViewState.snapped || viewState === appViewState.fullScreenPortrait);
        },

        // Ta funkcja jest wywoływana, gdy użytkownik przechodzi do tej strony. To
        // wypełnia elementy strona danymi aplikacji.
        ready: function (element, options) {
            var listView = element.querySelector(".itemlist").winControl;

            // Przechowuj informacje o grupie i wyborze, które ta strona
            // wyświetli.
            this.group = (options && options.groupKey) ? Data.resolveGroupReference(options.groupKey) : Data.groups.getAt(0);
            this.items = Data.getItemsFromGroup(this.group);
            this.itemSelectionIndex = (options && "selectedIndex" in options) ? options.selectedIndex : -1;

            element.querySelector("header[role=banner] .pagetitle").textContent = this.group.title;

            // Ustaw element ListView.
            listView.itemDataSource = this.items.dataSource;
            listView.itemTemplate = element.querySelector(".itemtemplate");
            listView.onselectionchanged = this.selectionChanged.bind(this);
            listView.layout = new ui.ListLayout();

            this.updateVisibility();
            if (this.isSingleColumn()) {
                if (this.itemSelectionIndex >= 0) {
                    // Dla widoku pojedynczej kolumny załaduj artykuł.
                    binding.processAll(element.querySelector(".articlesection"), this.items.getAt(this.itemSelectionIndex));
                }
            } else {
                if (nav.canGoBack && nav.history.backStack[nav.history.backStack.length - 1].location === "/pages/split/split.html") {
                    // Wyczyść historię nawigacji, aby obsłużyć przypinanie, wychodzenie,
                    // odpinanie i wracania na stronę przez użytkownika.
                    nav.history.backStack.pop();
                }
                // Jeśli ta strona posiada element selectionIndex, spraw aby zaznaczenie
                // pojawiło się w elemencie ListView.
                listView.selection.set(Math.max(this.itemSelectionIndex, 0));
            }
        },

        selectionChanged: function (args) {
            var listView = document.body.querySelector(".itemlist").winControl;
            var details;
            var that = this;
            // Domyślnie, zaznaczenie jest ograniczone do pojedynczego elementu.
            listView.selection.getItems().done(function updateDetails(items) {
                if (items.length > 0) {
                    that.itemSelectionIndex = items[0].index;
                    if (that.isSingleColumn()) {
                        // Jeśli przypięty lub pionowy, nawiguj do nowej strony, zawierającej
                        // szczegóły wybranego elementu.
                        nav.navigate("/pages/split/split.html", { groupKey: that.group.key, selectedIndex: that.itemSelectionIndex });
                    } else {
                        // Jeśli pełnoekranowy lub wypełniony, aktualizuj kolumnę szczegółów nowymi danymi.
                        details = document.querySelector(".articlesection");
                        binding.processAll(details, items[0].data);
                        details.scrollTop = 0;
                    }
                }
            });
        },

        unload: function () {
            this.items.dispose();
        },

        // Ta funkcja aktualizuje układ strony w odpowiedzi na zmiany elementu viewState.
        updateLayout: function (element, viewState, lastViewState) {
            /// <param name="element" domElement="true" />
            /// <param name="viewState" value="Windows.UI.ViewManagement.ApplicationViewState" />
            /// <param name="lastViewState" value="Windows.UI.ViewManagement.ApplicationViewState" />

            var listView = element.querySelector(".itemlist").winControl;
            var firstVisible = listView.indexOfFirstVisible;
            this.updateVisibility();

            var handler = function (e) {
                listView.removeEventListener("contentanimating", handler, false);
                e.preventDefault();
            }

            if (this.isSingleColumn()) {
                listView.selection.clear();
                if (this.itemSelectionIndex >= 0) {
                    // Jeśli aplikacja jest przypięta do jednokolumnowego widoku szczegółów,
                    // dodaj jednokolumnowy widok listy do historii nawigacji.
                    nav.history.current.state = {
                        groupKey: this.group.key,
                        selectedIndex: this.itemSelectionIndex
                    };
                    nav.history.backStack.push({
                        location: "/pages/split/split.html",
                        state: { groupKey: this.group.key }
                    });
                    element.querySelector(".articlesection").focus();
                } else {
                    listView.addEventListener("contentanimating", handler, false);
                    listView.indexOfFirstVisible = firstVisible;
                    listView.forceLayout();
                }
            } else {
                // Jeśli aplikacja jest odpięta od dwukolumnowego widoku, usuń
                // wystąpienia elementu splitPage, które zostały dodane do historii nawigacji.
                if (nav.canGoBack && nav.history.backStack[nav.history.backStack.length - 1].location === "/pages/split/split.html") {
                    nav.history.backStack.pop();
                }
                if (viewState !== lastViewState) {
                    listView.addEventListener("contentanimating", handler, false);
                    listView.indexOfFirstVisible = firstVisible;
                    listView.forceLayout();
                }

                listView.selection.set(this.itemSelectionIndex >= 0 ? this.itemSelectionIndex : Math.max(firstVisible, 0));
            }
        },

        // Ta funkcja przełącza widoczność dwóch kolumn bazujących na obecnym
        // stanie widoku i zaznaczeniu elementu.
        updateVisibility: function () {
            var oldPrimary = document.querySelector(".primarycolumn");
            if (oldPrimary) {
                utils.removeClass(oldPrimary, "primarycolumn");
            }
            if (this.isSingleColumn()) {
                if (this.itemSelectionIndex >= 0) {
                    utils.addClass(document.querySelector(".articlesection"), "primarycolumn");
                    document.querySelector(".articlesection").focus();
                } else {
                    utils.addClass(document.querySelector(".itemlistsection"), "primarycolumn");
                    document.querySelector(".itemlist").focus();
                }
            } else {
                document.querySelector(".itemlist").focus();
            }
        }
    });
})();
