package oo;

// tag::main[]
public class EqualsDemo {
    private int int1;
    private SomeClass obj1;

    /** Konstruktor. */
    public EqualsDemo(int i, SomeClass o) {
        int1 = i;
        if (o == null) {
            throw new IllegalArgumentException(
                               "Obiekt danych musi być różny od null.");
        }
        obj1 = o;
    }

    /** Konstruktor domyślny. */
    public EqualsDemo() {
        this(0, new SomeClass());
    }

    /** Typowa implementacja metody equals(). */
    @Override
    public boolean equals(Object o) {
        if (o == this)                    // <1>
            return true;

        if (o == null)                    // <2>
            return false;
        
        // Czy można rzutować do tej klasy?
        if (o.getClass() != EqualsDemo.class) // <3>
            return false;

        EqualsDemo other = (EqualsDemo)o; // OK, można rzutować.

        // Porównanie poszczególnych pól.           // <4>
        if (int1 != other.int1)           // Typy proste porównujemy bezpośrednio...
            return false;
        if (!obj1.equals(other.obj1))     // ...a obiekty przy użyciu metody equals().
            return false;
        return true;
    }
    
    // ...
// end::main[]
    
    // Nigdy nie przesłaniaj metody equals() bez jedoczesnego przesłonięcia metody hashCode().
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + int1;
		result = prime * result + ((obj1 == null) ? 0 : obj1.hashCode());
		return result;
	}
}
