package io;

import java.time.LocalDate;

/** Przedstawia wzorce zastosowania i przykłady kodów formatujących 
 * klasy Formatter.
 */
// tag::main[]
public class FormatterDates {
	public static void main(String[] args) {

        // Formatuje daty jako daty, np. 2020-06-28.	
		System.out.printf("%4d-%02d-%2d%n", 2020, 6, 28);

        // Formatuje pola bezpośrednio z obiektu Date: wszystkie kody
        // odwołują się do pierwszego parametru ("1$"), zakodowane
        // formaty określające postać dat nie są dostępne; patrz rozdział
        // poświęcony tworzeniu programów wielojęzycznych.
        LocalDate today = LocalDate.now();
        // Wyświetla datę w postaci: 4 września 2020.
        System.out.printf("Dzisiaj jest %1$td %1$tB %1$tY r.%n", today);
	}
}
// end::main[]
