package dir_file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

/**
 * Zmiana nazwy pliku w Javie
 * @author Ian F. Darwin, http://www.darwinsys.com/
 */
// tag::main[]
public class Rename {
    public static void main(String[] argv) throws IOException {
        
        // Tworzymy obiekt Path. NIE należy tworzyć tego pliku na dysku!
        final Path p = Path.of("MyCoolDocument"); // Przenoszony plik.
        
        // Przygotowanie do wykonania programu: tworzymy nowy "stary" plik.
        final Path oldName = Files.exists(p) ? p : Files.createFile(p);
        
        // Zmieniamy nazwę kopii pliku na "mydoc.bak".
        // Zmiana nazwy wymaga obiektu Path określającego nazwę docelową.
        final Path newName = Path.of("mydoc.bak");
        Files.deleteIfExists(newName); // Na wypadek, gdyby plik już istniał.
        Path p2 = Files.move(oldName, newName);
        System.out.println("Zmieniono nazwę pliku z" + p + " na " + p2);
    }
}
// end::main[]
