package threads;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;

// tag::main[]
/** Sprite jest obrazkiem (obiektem Image) samodzielnie poruszającym się 
 * po ekranie.
 */
public class Sprite extends Component implements Runnable {
    private static final long serialVersionUID = 1L;
    protected static int spriteNumber = 0;
    protected int number;
    protected int x, y;
    protected Component parent;
    protected Image image;
    protected volatile boolean done = false;
    /** Czas w milisekundach pomiędzy kolejnymi przesunięciami. */
    protected volatile int sleepTime = 250;
    /** Kierunek ruchu danego obrazka. */
    protected Direction direction;
    enum Direction {
        VERTICAL, HORIZONTAL, DIAGONAL
    }
    /** Tworzy obiekt Sprite, dysponując komponentem nadrzędnym, obrazkiem
     * oraz kierunkiem ruchu.
     * Tworzy i uruchamia wątek (obiekt Thread) obsługujący danego "duszka".
     */
    public Sprite(Component parent, Image image, Direction direction) {
        this.parent = parent;
        this.image = image;
        this.direction = direction;
        this.number = Sprite.spriteNumber++;
        setSize(image.getWidth(this), image.getHeight(this));
    }

    /** Tworzy obiekt Sprite używając domyślnego kierunku ruchu. */
    public Sprite(Component parent, Image image) {
        this(parent, image, Direction.DIAGONAL);
    }

    /** Metoda zatrzymuje "duszka". */
    public void stop() {
        System.out.println("Stopping " + number);
        done = true;
    }

    /** Metoda zmienia szybkość ruchu. */
    protected void setSleepTime(int n) {
        sleepTime = n;
    }

    /**
     * Przesuwamy "duszka" po ekranie.
     * Ta wersja programu umożliwia jedynie ruch w poziomie, pionie 
     * oraz po skosie (pod kątem 45 stopni).
     */
    public void run() {
        int width = parent.getSize().width;
        int height = parent.getSize().height;
        // Określenie losowego położenia początkowego.
        x = (int)(Math.random() * width);
        y = (int)(Math.random() * height);
        // Losowy wybór kierunków ruchu w pionie i poziomie.
        int xincr = Math.random()>0.5?1:-1;
        int yincr = Math.random()>0.5?1:-1;
        while (!done) {
            width = parent.getSize().width;
            height = parent.getSize().height;
            if ((x+=xincr) >= width)
                x=0;
            if ((y+=yincr) >= height)
                y=0;
            if (x<0)
                x = width;
            if (y<0)
                y = height;
            switch(direction) {
                case VERTICAL: 
                    x = 0;
                    break;
                case HORIZONTAL: 
                    y = 0;
                    break;
                case DIAGONAL:
                    // Przeniesienie na przeciwległą krawędź.
                    break;
            }
            // System.out.println("z miejsca " + getLocation() + "->" + x + "," + y);
            setLocation(x, y);
            repaint();
            try {
                Thread.sleep(sleepTime);
            } catch (InterruptedException e) {
                return;
            }
        }
    }

    /** paint - wyświetlamy obrazek w wyznaczonym, bieżącym położeniu. */
    public void paint(Graphics g) {
        g.drawImage(image, 0, 0, this);
    }
}
// end::main[]
