package threads;

import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

// TODO: tłumaczenie nagłówka

/**
 * Program odczytuje przypomnienia z pliku i wyświetla je o wskazanym 
 * czasie używając do tego celu klasy java.util.Timer
 * Dane wejściowe mają mieć postać:
 * 2021 12 25 10 30 Prześpij się trochę.
 * Używa starej klasy java.util.Date,gdyż wymaga tego usługa TimerService.
 */
// tag::main[]
public class ReminderService {

    /** Obiekt Timer. */
    Timer timer = new Timer();

    class Item extends TimerTask {
        String message;
        Item(String m) {
            message = m;
        }
        public void run() {
            message(message);
        }
    }

    public static void main(String[] argv) throws Exception {
        new ReminderService().loadReminders();
    }

    private String dfPattern = "yyyy MM dd hh mm ss";
    private SimpleDateFormat formatter = new SimpleDateFormat(dfPattern);

    protected void loadReminders() throws Exception {

        Files.lines(Path.of("ReminderService.txt")).forEach(aLine -> {

            ParsePosition pp = new ParsePosition(0);
            Date date = formatter.parse(aLine, pp);
            String task = aLine.substring(pp.getIndex());
            if (date == null) {
                System.out.println("Nieprawidłowa data w wierszu " + aLine);
                return;
            }
            System.out.println("Data = " + date + "; zadanie = " + task);
            timer.schedule(new Item(task), date);
        });
    }
    // end::main[]

    /** Metoda wyświetla komunikat na konsoli i w graficznym interfejsie 
     * użytkownika aplikacji. Jest używana zarówno przez zadania klasy Item,
     * jak i przez główny analizator pliku z danymi.
     */
    void message(String message) {
        System.out.println("\007" + message);
    }
}
