package otherlang;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

// tag::main[]
/**
 * Przykład wykorzystania mechanizmu skryptowego Pythona (jython) w celu pobrania
 * wartości zmiennej, wyświetlenia jej i zmodyfikowania.
 * @author Ian Darwin
 */
public class PythonFromJava {
    private static final String PY_SCRIPTNAME = "pythonfromjava.py";

    public static void main(String[] args) throws Exception {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        
        ScriptEngine engine = scriptEngineManager.getEngineByName("python");
        if (engine == null) {
            final String message = 
                "Nie można znaleźć mechanizmu skryptowego 'python'; " + 
                "proszę go dodać do zmiennej środowiskowej CLASSPATH";
            System.out.println(message);
            System.out.println("Lista dostępnych mechanizmów skryptowych: ");
            scriptEngineManager.getEngineFactories().forEach(factory ->
                System.out.println(factory.getLanguageName()));
            throw new IllegalStateException(message);	
        }

        final Bindings bindings = engine.getBindings(ScriptContext.ENGINE_SCOPE);
        bindings.put("meaning", 42);
        
        // Uruchamiamy skrypt napisany w Pythonie i zapisany na dysku (no dobra, 
        // w jednym z katalogów wymienionych w zmiennej środowiskowej CLASSPATH).
        InputStream is =
            PythonFromJava.class.getResourceAsStream("/" + PY_SCRIPTNAME);
        if (is == null) {
            throw new IOException("Nie można znaleźć pliku " + PY_SCRIPTNAME);
        }
        engine.eval(new InputStreamReader(is));
        System.out.println("Java: zmienna meaning ma teraz wartość " + 
                    bindings.get("meaning"));
    }
}
// end::main[]
