package io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

// TODO: przetłumaczyć nagłówek 

/** TeePrintStream tees all PrintStream operations into a file, rather
 * like the UNIX tee(1) command. It is a PrintStream subclass. The
 * expected usage would be something like the following:
 * <PRE>  
 *	...
 *	TeePrintStream ts = new TeePrintStream(System.err, "err.log");
 *	System.setErr(ts);
 *	// ...lots of code that occasionally writes to System.err...
 *	ts.close();
 *	...
 * <PRE>
 * <P>I only override Constructors, the write(), check() and close() methods,
 * since any of the print() or println() methods must go through these.
 * Thanks to Svante Karlsson for help formulating this.
 * <br/>
 * Note: there is another way of doing this, using a FilterStream;
 * see the example at http://www.javaspecialists.eu/archive/Issue003.html
 * (written a year after the initial import of my version).
 * @author Ian F. Darwin, http://www.darwinsys.com/
 */
// tag::main[]
public class TeePrintStream extends PrintStream {
	/** Strumień początkowy/bezpośredni. */
	protected PrintStream parent;

    /** Nazwa pliku, jeśli jest znana.
     * Być może w przyszłości zostanie zastosowana do wyświetlania
     * komunikatów o błędach.
	 */
	protected String fileName;

	/** Nazwa używana w sytuacjach, gdy nazwa pliku nie jest znana. */
	private static final String UNKNOWN_NAME = "(opened Stream)";

    /** Tworzymy obiekt TeePrintStream, dysponując istniejącym 
     * obiektem PrintStream, otworzonym obiektem OutputStream
     * oraz wartością logiczną określającą automatyczne opróżnianie
     * bufora.
     * To jest główny konstruktor, wszystkie inne korzystają z niego.
	 */
	public TeePrintStream(PrintStream orig, OutputStream os, boolean flush)
	throws IOException {
		super(os, true);
		fileName = UNKNOWN_NAME;
		parent = orig;
	}

    /** Tworzymy obiekt TeePrintStream, dysponując istniejącym 
     * obiektem PrintStream oraz otworzonym obiektem OutputStream.
     */
	public TeePrintStream(PrintStream orig, OutputStream os)
	throws IOException {
		this(orig, os, true);
	}

    /** Tworzymy obiekt TeePrintStream, dysponując istniejącym 
     * obiektem PrintStream oraz nazwą pliku.
     */
	public TeePrintStream(PrintStream os, String fn) throws IOException {
		this(os, fn, true);
	}

    /** Tworzymy obiekt TeePrintStream, dysponując istniejącym 
     * obiektem Stream, nazwą pliku oraz wartością logiczną określającą 
     * automatyczne opróżnianie bufora.
     */
	public TeePrintStream(PrintStream orig, String fn, boolean flush)
	throws IOException {
		this(orig, new FileOutputStream(fn), flush);
		fileName = fn;
	}

    /** Zwraca true, jeśli w którymś ze strumieni 
     * pojawiły się błędy.
     */
	public boolean checkError() {
		return parent.checkError() || super.checkError();
	}

    /** Przesłonięta metoda write(). Faktyczna operacja powielania. */
    public void write(int x) {
        parent.write(x);         // Zapisujemy w jednym miejscu
        super.write(x);          // i w innym.
	}

    /** Przesłonięta metoda write(). Faktyczna operacja powielania. */
    public void write(byte[] x, int o, int l) {
        parent.write(x, o, l);       // Zapisujemy w jednym miejscu
        super.write(x, o, l);        // i w innym.
	}

	/** Zamykamy oba strumienie. */
	public void close() {
		parent.close();
		super.close();
	}

	/** Opróżniamy oba strumienie. */
	public void flush() {
		parent.flush();
		super.flush();
	}
}
// end::main[]
