package io;

import java.io.Console;

/**
 * Odczyt hasła od użytkownika.
 * WYMAGA JAVA 6 lub nowszej.
 */
// tag::main[]
public class ReadPassword {
	public static void main(String[] args) {
		Console cons;
		if ((cons = System.console()) != null) {
			char[] passwd = null;
			try {
				passwd = cons.readPassword("Hasło:");
				// W rzeczywistym zastosowaniu hasło byłoby przesyłane w kodzie uwierzytelniającym.
				System.out.println("Przesłałeś hasło: " + new String(passwd));
			} finally {
				// Usywamy hasło przechowywane w pamięci, ze względów bezpieczeństwa.
				if (passwd != null) {
					java.util.Arrays.fill(passwd, ' ');
				}
			}
		} else {
			throw new RuntimeException("Brak konsoli, nie można pobrać hasła!");
		}
	}
}
// end::main[]
