package io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.*;
import java.util.List;

/**
 * Kilka sposobów odczytu pliku o podanej nazwie i przetwarzania
 * jego zawartości wiersz po wierszu
 */
public class ReadLines {

    @SuppressWarnings("resource")
    public static void main(String[] args) throws IOException {
        String fileName = args[0];

        // tag::main[]
        System.out.println("Użycie metody Path.lines()");
        Files.lines(Path.of(fileName)).forEach(System.out::println);
        
        System.out.println("Użycie metody Path.readAllLines()");
        List<String> lines = Files.readAllLines(Path.of(fileName));
        lines.forEach(System.out::println);
        
        System.out.println("Użycie metody BufferedReader.lines().forEach()");
        new BufferedReader(new FileReader(fileName)).lines().forEach(s -> {
            System.out.println(s);
        });
        
        System.out.println("Stary sposób");
        BufferedReader is = new BufferedReader(new FileReader(fileName));
        String line;
        while ((line = is.readLine()) != null) {
            System.out.println(line);
        }
        // end::main[]
    }
}
