import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.Dataset;
import org.apache.spark.api.java.function.FilterFunction;

/**
* Wczytuje plik dziennika serwera Apache i podsumowuje jego zawartość.
*/
public class LogReader {
  public static void main(String[] args) {
    final String logFile = "/var/wildfly/standalone/log/access_log.log";
    SparkSession spark =
      SparkSession.builder().appName("Analizator dziennika").getOrCreate();
    Dataset<String> logData = spark.read().textFile(logFile).cache();
    
    long good = logData.filter(
        new FilterFunction<>() {public boolean call(String s) {
          return s.contains("200");
        }
      }).count();

    long bad = logData.filter(new FilterFunction<>() {
        public boolean call(String s) {
          return s.contains("404");
        }
      }).count();

    long ugly = logData.filter(new FilterFunction<>() {
        public boolean call(String s) {
          return s.contains("500");
        }
      }).count();

    System.out.printf(
      "Liczby żądań pomyślnie obsłużonych: %d, błędów 404: %d, błędów serwera (500): %d\n",
      good, bad, ugly);

    spark.stop();
  }
}