package structure;

import java.util.Arrays;
import java.util.Comparator;

/** Prezentacja stosowania klasy SubstringComparator.
 */
// tag::main[]
public class SubstringComparatorDemo {
	public static void main(String[] unused) {
		String[] strings = {
            "bolesny", 
            "głównie",
            "opad",
            "krople"
		};
		Arrays.sort(strings);
        dump(strings, "Używamy domyślnego sposobu sortowania:");
        Arrays.sort(strings, new SubstringComparator());
        dump(strings, "Używamy klasy SubstringComparator:");

		// tag::functional[]
		System.out.println("Rozwiązanie funkcyjne:");
		Arrays.stream(strings)
			.sorted(Comparator.comparing(s->s.substring(1)))
			.forEach(System.out::println);
		// end::functional[]
	}
	
	static void dump(String[] args, String title) {
		System.out.println(title);
		for (String s : args)
			System.out.println(s);
	}
}
// end::main[]
