package structure;

import java.time.LocalDateTime;

/** Ponowna alokacja tablic, tylko większych...
 * @author Ian Darwin
 */
// tag::main[]
public class Array2  {
    public final static int INITIAL = 10,   // <1>
        GROW_FACTOR = 2;                    // <2>

    public static void main(String[] argv) {
        int nDates = 0;
        LocalDateTime[] dates = new LocalDateTime[INITIAL];
        StructureDemo source = new StructureDemo(21);
        LocalDateTime c;
        while ((c=source.getDate()) != null) {

            // if (nDates >= dates.length) {
            //     throw new RuntimeException(
			//         "Zbyt wiele dat! Uprość sobie życie!");
            // }

            // Lepsze: ponowne przydzielenie pamięci, zapewniające 
            // dynamiczność struktury.
            if (nDates >= dates.length) {
                LocalDateTime[] tmp = 
					new LocalDateTime[dates.length * GROW_FACTOR];
                System.arraycopy(dates, 0, tmp, 0, dates.length);
                dates = tmp;    // Kopiujemy odwołanie do tablicy.
                // Oryginalna tablica zostanie wkrótce usunięta 
                // przez narzędzia oczyszczania pamięci...
            }
            dates[nDates++] = c;
        }
        System.out.println("Końcowa wielkość tablicy = " + dates.length);
    }
}
// end::main[] 
