package structure;

import java.time.LocalDate;

/** Przegląd przykładów związanych z tablicami: pokazuje tworzenie tablic,
 * przetwarzanie ich, zapisywanie obiektów w tablicach, tablice dwuwymiarowe,
 * oraz odczyt długości tablic.
 *
 * @author Ian Darwin
 */
// tag::main[]
public class Array1  {
	@SuppressWarnings("unused")
	public static void main(String[] argv) {
        int[] monthLen1;            // Deklarujemy odwołanie.
        monthLen1 = new int[12];        // Tworzymy je.
        int[] monthLen2 = new int[12];    // Zapis skrócony.
        // Jeszcze prostszy jest poniższy sposób inicjalizacji: 
		int[] monthLen3 = {
				31, 28, 31, 30,
				31, 30, 31, 31,
				30, 31, 30, 31,
		};
		
		final int MAX = 10;
		LocalDate[] days = new LocalDate[MAX];
		for (int i=0; i<MAX; i++) {
			days[i] = LocalDate.of(2022, 02, i + 1);
		}
	 
        // Tablice dwuwymiarowe.
        // Tworzymy tablicę 10x24.
		int[][] me = new int[10][];
		for (int i=0; i<10; i++)
			me[i] = new int[24];

        // Pamiętajmy, że tablice mają właściwość length.
		System.out.println(me.length);
		System.out.println(me[0].length);

	}
}
// end::main[]
