package oo;

/**
 * Implementacja wzorca Singleton w Javie która nadużywa mechanizmu 
 * typów wyliczeniowych w Javie w celu zagwarantowania utworzenia 
 * sigletonów.
 * Wzorzec Singleton został opisany w książce GoF, polega na tym
 * by zagwarantować, że w jednej aplikacji będzie istnieć tylko jedna
 * instancja danej klasy.
 * @author Ian F. Darwin, http://www.darwinsys.com/
 */
// tag::main[]
public enum EnumSingleton {

    INSTANCE;

    // Tu można umieścić metody instancyjne. Charakter typu,
    // będącego singletonem, sprawi, że będą one chronione.

    /** Prosta metoda demonstracyjna. */
    public String demoMethod() {
        return "demo";
    }
}
// end::main[]
