package network;

import java.io.*;
import java.net.*;
/**
 * EchoClientOneLine - tworzy gniazdo klienta, wysyła wiersz tekstu i odczytuje
 * go z powrotem. Zobacz także nieco bardziej wyszukaną klasę EchoClient.java.
 */
// tag::main[]
public class EchoClientOneLine {
	/** Wysyłany tekst */
	String mesg = "Witamy inny komputer w sieci";

	public static void main(String[] argv) {
		if (argv.length == 0)
			new EchoClientOneLine().converse("localhost");
		else
			new EchoClientOneLine().converse(argv[0]);
	}

	/** Wymiana informacji za pośrednictwem sieci */
	protected void converse(String hostName) {
		try (Socket sock = new Socket(hostName, 7);) { // Serwer Echo
			BufferedReader is = new BufferedReader(new 
				InputStreamReader(sock.getInputStream()));
			PrintWriter os = new PrintWriter(sock.getOutputStream(), true);
            // Sami obsługujemy CRLF, gdyż metoda println dodaje \r tylko 
            // w systemach, gdzie to zakończenie wierszy jest stosowane.
            os.print(mesg + "\r\n"); os.flush();
            String reply = is.readLine();
            System.out.println("Wysłano \"" + mesg  + "\"");
            System.out.println("Odebrano \"" + reply + "\"");
		} catch (IOException e) {
			System.err.println(e);
		}
	}
}
// end::main[]
