package functional;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

/**
 * Zamiennik uniksowego polecenia:
 *   cat lines.txt | sort | uniq | wc -l
 * Nawet zwraca te same wyniki :-)
 */
public class UnixPipesFiltersReplacement {

	public static void main(String[] args) throws IOException {
		// tag::main[]
		long numberLines = Files.lines(Path.of(("lines.txt")))
			.sorted()
			.distinct()
			.count();
		System.out.printf("Plik lines.txt zawiera " + numberLines + " unikalnych wierszy.");
		// end::main[]
	}
}
