package dir_file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

/**
 * Korzystanie z plików tymczasowych w Javie.
 * @author Ian F. Darwin, http://www.darwinsys.com/
 */
// tag::main[]
public class TempFiles {
    public static void main(String[] argv) throws IOException {

        // 1. Określamy, że istniejący plik będzie plikiem tymczasowym.

        // Tworzymy obiekt File dla kopii zapasowej utworzonej poprzez
        // edycję tego pliku źródłowego. Ta kopia najprawdopodobniej już 
        // istnieje. Używany przeze mnie edytor tworzy takie kopie, 
        // dodając znak "~" na końcu nazwy oryginalnego pliku.
        File bkup = new File("Rename.java~");
        // Nakazujemy usunięcie tego pliku pod koniec działania programu.
        bkup.deleteOnExit();

        // 2. Tworzymy nowy plik tymczasowy.

        // Tworzymy nowy obiekt dla pliku foo.tmp, który zostanie utworzony
        // w domyślnym katalogu plików tymczasowych.
        Path tmp = Files.createTempFile("foo", "tmp");
        // Wyświetlamy informacje o utworzonym pliku.
        System.out.println("Używamy pliku tymczasowego " + tmp.normalize());
        // Nakazujemy usunięcie pliku podczas kończenia programu.
        tmp.toFile().deleteOnExit();
        // Teraz można w dowolny sposób wykorzystać plik tymczasowy,
        // bez konieczności pamiętania o tym, że należy go usunąć.
        writeDataInTemp(tmp);
    }

    public static void writeDataInTemp(Path tempFile) throws IOException {
        // Ta metoda jest pusta... można ją wykorzystać wedle własnego uznania.
        Files.writeString(tempFile, "To jest plik tymczasowy");
    }
}
// end::main[]
