package dir_file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.logging.Logger;

// tag::main[]
/**
 * Find - odnajduje pliki na podstawie nazwy, wielkości lub innych kryteriów.
 * Wersja bez graficznego interfejsu użytkownika.
 */
public class Find {
    
    public enum Conjunction { AND, OR };
    
    private static Logger logger = Logger.getLogger(Find.class.getSimpleName());
    static boolean started;
    
    /** Program główny.
     * @throws IOException jeśli zostanie zgłoszony przez Files.walkTree.
     */
    public static void main(String[] args) throws IOException {
        Find finder = new Find();
        
        if (args.length == 0) {
            finder.startWalkingAt(".");
        } else {
            for (int i = 0; i < args.length; i++) {
                if (args[i].charAt(0) == '-') {
                    switch(args[i].substring(1)) {
                    case "name":
                        finder.filter.setNameFilter(args[++i]);
                        continue;
                    case "size":
                        finder.filter.setSizeFilter(args[++i]);
                        continue;
//					Jeszcze nie zaimplementowano opcji
//					case "a":
//						finder.filter.addConjunction(Conjunction.AND);
//						continue;
//					case "o":
//						finder.filter.addConjunction(Conjunction.OR);
//						continue;
                    default: throw new IllegalArgumentException(
                        "Nieznany argument " + args[i]);
                    }
                }
                finder.startWalkingAt(args[i]);
            }
            if (!started) {
                finder.startWalkingAt(".");
            }
        }
    }

    protected FindFilter filter = new FindFilter();

    public static void usage() {
        System.err.println(
            "Sposób użycia: Find [-n filtr_nazw][-s filtr_wielkości][katalog...]");
        System.exit(1);
    }

    /** doName - obsługuje poszukiwanie elementu systemu plików
     * na podstawie podanej nazwy.
     */
    private void startWalkingAt(String s) throws IOException {
        logger.info("doName(" + s + ")");
        started = true;
        Path f = Path.of(s);
        if (!Files.exists(f)) {
            System.out.println(s + " nie istnieje");
            return;
        }
        Files.walk(f).forEach(fp -> {
            try {
                if (Files.isRegularFile(fp))
                    doFile(fp);
                else if (Files.isDirectory(fp)) {
                    doDir(fp);
                } else {
                    System.err.println("Nieznany typ: " + s);
                }
            } catch (IOException e) {
                throw new RuntimeException("Wyjątek wejścia-wyjścia: " + e);
            }
        });
    }

    /** doFile - przetworzenie jednego, zwyczajnego pliku.
     * @throws IOException */
    private void doFile(Path f) throws IOException {
        if (filter.accept(f)) {
            System.out.println("f " + f);
        }
    }
    
    /** doDir - przetworzenie katalogu. */
    private void doDir(Path d) {
        System.out.println("d " + d.normalize());
    }
}
// end::main[]
