package dir_file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

/**
 * Usuwanie pliku z obsługą błędów.
 * Przygotowanie w systemach *Nix:
 touch a; mkdir b; mkdir c; touch c/d
 * @author Ian F. Darwin, http://www.darwinsys.com/
 */
// tag::main[]
public class Delete2 {

    static boolean hard = false; // True - użycie delete, false - użycie deleteIfExists.

    public static void main(String[] argv) {
        for (String arg : argv) {
            if ("-h".equals(arg)) {
                hard = true;
                continue;
            }
            delete(arg);
        }
    }

    public static void delete(String fileName) {
        // Tworzymy obiekt File reprezentujący usuwany plik.
        final Path target = Path.of(fileName);

        // A teraz go usuwamy.
        if (hard) {
            try {
                System.out.print("Użycie metody Files.delete(): ");
                Files.delete(target);
                System.err.println("** Usunięto " + fileName + " **");
            } catch (IOException e) {
                System.out.println("Podczas usuwania " + fileName + " zgłoszono wyjątek " + e);
            }
        } else {
            try {
                System.out.print("Użycie metody deleteIfExists(): ");
                if (Files.deleteIfExists(target)) {
                    System.out.println("** Usunięto " + fileName + " **");
                } else {
                    System.out.println(
                        "Operacja usunięcia " + fileName + " zwróciła false.");
                }
            } catch (IOException e) {	
                System.out.println("Podczas usuwania " + fileName + " zgłoszono wyjątek " + e);
            }
        }
    }
}
// end::main[]
