package domain;

public class Person {

	int id;
	protected String firstName;
	protected String lastName;
	
	public Person() {
        // Wymagane przez JPA; musimy zaimplementować, gdyż potrzebujemy
        // konstruktora dwuargumentowego.
	}
	
	public Person(String firstName, String lastName) {
		this.firstName = firstName;
		this.lastName = lastName;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}
	
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	@Override
	public String toString() {
		return getFullName();
	}
	
	public String getFullName() {
		StringBuilder sb = new StringBuilder();
		if (firstName != null)
			sb.append(firstName).append(' ');
		if (lastName != null)
			sb.append(lastName);
		if (sb.length() == 0)
			sb.append("Brak danych");
		return sb.toString();
	}
}
// end::main[]