@Path("")
@ApplicationScoped
public class RestService {

    public RestService() {
        System.out.println("RestService.init()");
    }

    @GET
    @Path("/timestamp")
    @Produces(MediaType.TEXT_PLAIN)
    public String getDate() {
        return LocalDateTime.now().toString();
    }

    /** Metoda wyświetlająca komunikat.
     */
    @GET
    @Path("/greeting/{userName}")
    @Produces("text/html")
    public String doGreeting(@PathParam("userName") String userName) {
        System.out.println("RestService.greeting()");
        if (userName == null || userName.trim().length() <= 3) {
            return "Brak nazwy lub nazwa za krotka";
        }
        return String.format(
            "<h1>Witam %s</h1><p>%s, fajnie ze jestes!",
            userName,
            userName
        );
    }

    /** Metoda używana do pobierania wszystkich elementów. */
    @GET
    @Path("/names")
    @Produces(MediaType.APPLICATION_JSON)
    public List<String> findTasksForUser() {
        return List.of("Robert", "Karol", "Ewa", "Gabriela");
    }
}
