
/** Listing 11.4. */

class ScriptingFile {
  
  private static final String R_SCRIPT_FILE = "/randomnesshistograms.r";
  private static final int N = 10000;

  public static void main(String[] argv) throws Exception {
    // Metody klasy java.util.Random nie są statyczne, musimy
    // zatem utworzyć instancję tej klasy, by z nich korzystać.
    Random r = new Random();
    double[] us = new double[N], ns = new double[N];
    for (int i=0; i<N; i++) {
      us[i] = r.nextDouble();
      ns[i] =r.nextGaussian();
    }
    try (InputStream is =
      Random5.class.getResourceAsStream(R_SCRIPT_FILE)) {
      if (is == null) {
        throw new IllegalStateException("Nie można otworzyć pliku R");
      }
      ScriptEngineManager manager = new ScriptEngineManager();
      ScriptEngine engine = manager.getEngineByName("Renjin");
      engine.put("us", us);
      engine.put("ns", ns);
      engine.eval(FileIO.readerToString(new InputStreamReader(is)));
    }
  }

}
