package nio;

import static java.nio.file.StandardWatchEventKinds.ENTRY_CREATE;
import static java.nio.file.StandardWatchEventKinds.ENTRY_MODIFY;

import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchEvent.Kind;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * Pokazuje użycie klasy JavaSE NIO WatchService.
 */
// tag::main[]
public class FileWatchServiceDemo {

    final static String TEMP_DIR_PATH = "/tmp";
    static final String FILE_SEMA_FOR = "MyFileSema.for";
    final static Path SEMAPHORE_PATH = Path.of(TEMP_DIR_PATH ,FILE_SEMA_FOR);
    static volatile boolean done = false;
    final static ExecutorService threadPool = Executors.newSingleThreadExecutor();

    public static void main(String[] args) throws Throwable {
        String tempDirPath = "/tmp";
        System.out.println("Rozpoczynanie obserwacji katalogu " + tempDirPath);
        System.out.println("Plik semafora: " + SEMAPHORE_PATH);
        Path p = Paths.get(tempDirPath);
        WatchService watcher = 
            FileSystems.getDefault().newWatchService();
        Kind<?>[] watchKinds = { ENTRY_CREATE, ENTRY_MODIFY };
        p.register(watcher, watchKinds);
        threadPool.submit(new DemoService());
        while (!done) {
            WatchKey key = watcher.take();
            for (WatchEvent<?> e : key.pollEvents()) {
                System.out.println(
                    "Zdarzenie " + e.kind() + " dotyczące " + 
                    e.context());
                if (e.context().toString().equals(FILE_SEMA_FOR)) {
                    System.out.println("Znaleziono semafor, zamykanie obserwatora");
                    done = true;
                }
            }
            if (!key.reset()) {
                System.err.println("Nie udało się zresetować klucza!");
            }
        }
    }

    /**
     * Klasa zagnieżdżona, której jedynym celem jest poczekać chwilę,
     * utworzyć plik w monitorowanym katalogu i zakończyć działanie
     */
    private final static class DemoService implements Runnable {
        public void run() {
            try {
                Thread.sleep(1000);
                System.out.println("DemoService: Tworzenie pliku");
                Files.deleteIfExists(SEMAPHORE_PATH); // porządki po porzednim wykonaniu
                Files.createFile(SEMAPHORE_PATH);
                Thread.sleep(1000);
                System.out.println("DemoService: zatrzymywanie usługi");
            } catch (Exception e) {
                System.out.println("Przechwycono NIEOCZEKIWANY wyjątek " + e);
            }
        }
    }
}
// end::main[]
