package i18n;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;

/** Stosowanie ustawień lokalnych w oparciu o "ustawienia" systemu użytkownika
 * lub zgodnie z wartością opcji -Duser.lang= bądź -Duser.region=.
 */
// tag::main[]
public class UseLocales {
	public static void main(String[] args) {

		Locale frLocale = Locale.FRANCE;	// Predefiniowane.
		Locale ukLocale = new Locale("en", "UK");	// Ustawienia dla Anglii i języka angielskiego.

		DateTimeFormatter defaultDateFormatter = 
			DateTimeFormatter.ofLocalizedDateTime(
				FormatStyle.MEDIUM);
		DateTimeFormatter frDateFormatter = 
			DateTimeFormatter.ofLocalizedDateTime(
				FormatStyle.MEDIUM).localizedBy(frLocale);
		DateTimeFormatter ukDateFormatter = 
			DateTimeFormatter.ofLocalizedDateTime(
				FormatStyle.MEDIUM).localizedBy(ukLocale);

		LocalDateTime now = LocalDateTime.now();
		System.out.println("Ustawienia domyślne:" + ' ' +
			now.format(defaultDateFormatter));
		System.out.println(frLocale.getDisplayName() + ' ' +
			now.format(frDateFormatter));
		System.out.println(ukLocale.getDisplayName() + ' ' +
			now.format(ukDateFormatter));
	}
}
// end::main[]
