package datetime;

// tag::main[]
import java.time.LocalDate;
import java.time.Period;

/**
 * Przykład odejmowania dat.
 */
public class DateDiff {

	public static void main(String[] args) {
		/** Data ostatniego dnia ubiegłego wieku. */
		LocalDate endof20thCentury = LocalDate.of(2000, 12, 31);
		LocalDate now = LocalDate.now();
		if (now.getYear() > 2100) {
			System.out.println("XXI wiek już minął!");
			return;
		}
		
		Period diff = Period.between(endof20thCentury, now);
		
		System.out.printf(
			    "XXI wiek (do dziś, czyli %s) liczy już sobie %s lat.%n", 
		        now, diff);
		System.out.printf(
				"XXI wiek ma już %d lat, %d miesięcy i %d dni.",
				diff.getYears(), diff.getMonths(), diff.getDays());
	}
}
// end::main[]
