package io;

import static org.junit.Assert.assertEquals;

import java.io.IOException;
import java.io.StringReader;

import org.junit.Test;

/**
 * Test klasy IndentContLineReader
 */
public class IndentContLineReaderTest {

    protected final static String sampleTxt = 
        "From: ian today now\n" +
        "Received: by foo.bar.com\n" +
        "    at 12:34:56 January 1, 2000\n" +
        "X-Silly-Headers: Too Many\n" +
        "This line should be line 5.\n" +
        "Test more indented line continues from line 6:\n" +
        "    space indented.\n" +
        "    tab indented;\n" +
        "\n" +
        "This is line 10\n" + 
        "the start of a hypothetical mail/news message, \n" +
        "that is, it follows a null line.\n" +
        "    Let us see how it fares if indented.\n" +
        " also space-indented.\n" +
        "\n" +
        "How about text ending without a newline?";

    @Test
    public void testTwoLiner() throws IOException {
        String input = "Received: by foo.bar.com\n" +
                " at 12:34:56 January 1, 2000\n";
        String expected = "Received: by foo.bar.com at 12:34:56 January 1, 2000";
        try (IndentContLineReader is = new IndentContLineReader(
            new StringReader(input))) {
            assertEquals("2 liner", expected, is.readLine());
        }
    }
    
    /** To, tak na prawdę jest metoda demonstracyjna, a nie test; przepraszam. */
    public void showReadingAMailMessageWithHeaders() throws IOException {
        // BEGIN main
        IndentContLineReader is = new IndentContLineReader(
            new StringReader(sampleTxt));
        String aLine;
        // Wyświetlany nagłówki.
        System.out.println("----- Nagłówki wiadomości -----");
        while ((aLine = is.readLine()) != null && aLine.length() > 0) {
            System.out.println(is.getLineNumber() + ": " + aLine);
        }
        // Zmieniamy działanie obiektu "is" tak, aby zachowywał się      
        // w sposób bardziej zbliżony do obiektów klasy BufferedReader. 
        is.setContinuationMode(false);
        System.out.println();
        // Wyświetlamy treść wiadomości.
        System.out.println("----- Treść wiadomości -----");
        while ((aLine = is.readLine()) != null) {
            System.out.println(is.getLineNumber() + ": " + aLine);
        }
        is.close();
        // END main
    }
}
