package com.darwinsys.swingui.layout;

import java.awt.Container;
import java.awt.HeadlessException;

import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

import org.junit.Test;

/** Program do testowania menedżera układu EntryLayout.
 * @author    Ian Darwin, http://www.darwinsys.com/
 */
// BEGIN main
public class EntryLayoutTest {

    /** Metoda "główna" - stworzenie i wyświetlenie okna dialogowego */
    public static void main(String[] av) {
        testTwoCols();
        testFiveCols();
    }

    static void testTwoCols() {
        final JFrame f = new JFrame("Menedżer EntryLayout");
        Container cp = f.getContentPane();
        double widths[] = { .33, .66 };
        cp.setLayout(new EntryLayout(widths));
        cp.add(new JLabel("Użytkownik:", SwingConstants.RIGHT));
        cp.add(new JTextField(10));
        cp.add(new JLabel("Hasło:", SwingConstants.RIGHT));
        cp.add(new JPasswordField(20));
        cp.add(new JLabel("Domena bezp.:", SwingConstants.RIGHT));
        cp.add(new JTextField(20));
        // cp.add(new JLabel("Etykieta psująca układ"));
        f.pack();
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLocation(200, 200);
        f.setVisible(true);
    }

    static void testFiveCols() {
        final JFrame f = new JFrame("Układ z pięcioma kolumnami");
        Container cp = f.getContentPane();
        double widths[] = { .25, .33, .10, .10, .20 };
        cp.setLayout(new EntryLayout(widths));
        cp.add(new JLabel("Użytkownik:", SwingConstants.RIGHT));
        cp.add(new JTextField(10));
        cp.add(new JCheckBox());
        cp.add(new JCheckBox());
        cp.add(new JCheckBox());
        cp.add(new JLabel("Hasło:", SwingConstants.RIGHT));
        cp.add(new JPasswordField(20));
        cp.add(new JCheckBox());
        cp.add(new JCheckBox());
        cp.add(new JCheckBox());
        cp.add(new JLabel("Domena bezp.:", SwingConstants.RIGHT));
        cp.add(new JTextField(20));
        cp.add(new JCheckBox());
        cp.add(new JCheckBox());
        cp.add(new JCheckBox());
        f.pack();
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setLocation(200, 200);
        f.setVisible(true);
    }
    
    @Test
    public void trivialTest() {
        try {
            main(null);
        } catch (HeadlessException he) {
            System.out.println("EntryLayoutTest.test(): zgłoszono wyjątek HeadlessException");
        }
    }
}
// END main
