/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.runtime.windows;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.W32API;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import uk.co.caprica.vlcj.runtime.windows.internal.LowLevelMouseProc;
import uk.co.caprica.vlcj.runtime.windows.internal.MSLLHOOKSTRUCT;

public class WindowsMouseHook
implements LowLevelMouseProc {
    private static final Logger LOG = Logger.getLogger(WindowsMouseHook.class);
    private static User32 USER32_INSTANCE = User32.INSTANCE;
    private final EventListenerList listenerList = new EventListenerList();
    private final Component relativeTo;
    private Thread hookThread;
    private volatile User32.HHOOK hHook;

    public WindowsMouseHook(Component relativeTo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WindowsMouseHook(relativeTo=" + relativeTo + ")"));
        }
        if (!Platform.isWindows()) {
            throw new IllegalStateException("Windows only");
        }
        this.relativeTo = relativeTo;
    }

    public void addMouseListener(MouseListener listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addMouseListener(listener=" + listener + ")"));
        }
        this.listenerList.add(MouseListener.class, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removeMouseListener(listener=" + listener + ")"));
        }
        this.listenerList.remove(MouseListener.class, listener);
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addMouseMotionListener(listener=" + listener + ")"));
        }
        this.listenerList.add(MouseMotionListener.class, listener);
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removeMouseMotionListener(listener=" + listener + ")"));
        }
        this.listenerList.remove(MouseMotionListener.class, listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addMouseWheelListener(listener=" + listener + ")"));
        }
        this.listenerList.add(MouseWheelListener.class, listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("removeMouseWheelListener(listener=" + listener + ")"));
        }
        this.listenerList.remove(MouseWheelListener.class, listener);
    }

    public void start() {
        LOG.debug((Object)"start()");
        if (this.hookThread != null) {
            throw new IllegalStateException("Mouse hook already installed");
        }
        this.hookThread = new MouseHookThread();
        this.hookThread.start();
    }

    public synchronized void release() {
        LOG.debug((Object)"release()");
        User32.HHOOK hook = this.getHook();
        if (hook != null) {
            hook = null;
        }
        LOG.debug((Object)"released");
    }

    protected void finalize() throws Throwable {
        LOG.debug((Object)"finalize()");
        this.release();
    }

    private synchronized User32.HHOOK getHook() {
        return this.hHook;
    }

    public W32API.LRESULT callback(int nCode, W32API.WPARAM wParam, MSLLHOOKSTRUCT lParam) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("callback(nCode=" + nCode + ",wParam=" + wParam + ",lParam=" + (Object)((Object)lParam)));
        }
        if (nCode >= 0) {
            Window window = SwingUtilities.getWindowAncestor(this.relativeTo);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("window=" + window));
            }
            if (window != null && window.isActive()) {
                LOG.trace((Object)"window is active");
                if (this.relativeTo.isVisible() && this.relativeTo.isValid()) {
                    LOG.trace((Object)"window is visible");
                    int absX = lParam.pt.x;
                    int absY = lParam.pt.y;
                    Point componentPoint = this.relativeTo.getLocationOnScreen();
                    int relX = componentPoint.x;
                    int relY = componentPoint.y;
                    int relW = relX + this.relativeTo.getWidth();
                    int relH = relY + this.relativeTo.getHeight();
                    if (absX >= relX && absY >= relY && absX < relW && absY < relH) {
                        LOG.trace((Object)"event inside component bounds");
                        switch (wParam.intValue()) {
                            case 512: {
                                this.fireMouseMotionEvent(503, 0, lParam);
                                break;
                            }
                            case 513: {
                                this.fireMouseEvent(501, 1, lParam);
                                break;
                            }
                            case 514: {
                                this.fireMouseEvent(502, 1, lParam);
                                break;
                            }
                            case 516: {
                                this.fireMouseEvent(501, 2, lParam);
                                break;
                            }
                            case 517: {
                                this.fireMouseEvent(502, 2, lParam);
                                break;
                            }
                            case 519: {
                                this.fireMouseEvent(501, 3, lParam);
                                break;
                            }
                            case 520: {
                                this.fireMouseEvent(502, 3, lParam);
                                break;
                            }
                            case 522: {
                                this.fireMouseWheelEvent(507, lParam);
                                break;
                            }
                        }
                    }
                }
            }
        }
        return USER32_INSTANCE.CallNextHookEx(this.hHook, nCode, wParam, lParam.getPointer());
    }

    private void fireMouseMotionEvent(int eventType, int button, MSLLHOOKSTRUCT lParam) {
        MouseMotionListener[] listeners;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("fireMouseMotionEvent(eventType=" + eventType + ",button=" + button + ",lParam=" + (Object)((Object)lParam) + ")"));
        }
        if ((listeners = (MouseMotionListener[])this.listenerList.getListeners(MouseMotionListener.class)).length > 0) {
            MouseEvent evt = this.createMouseEvent(eventType, button, lParam);
            for (int i = listeners.length - 1; i >= 0; --i) {
                switch (eventType) {
                    case 503: {
                        listeners[i].mouseMoved(evt);
                    }
                }
            }
        }
    }

    private void fireMouseEvent(int eventType, int button, MSLLHOOKSTRUCT lParam) {
        MouseListener[] listeners;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("fireMouseEvent(eventType=" + eventType + ",button=" + button + ",lParam=" + (Object)((Object)lParam) + ")"));
        }
        if ((listeners = (MouseListener[])this.listenerList.getListeners(MouseListener.class)).length > 0) {
            MouseEvent evt = this.createMouseEvent(eventType, button, lParam);
            block4: for (int i = listeners.length - 1; i >= 0; --i) {
                switch (eventType) {
                    case 501: {
                        listeners[i].mousePressed(evt);
                        continue block4;
                    }
                    case 502: {
                        listeners[i].mouseReleased(evt);
                    }
                }
            }
        }
    }

    private void fireMouseWheelEvent(int eventType, MSLLHOOKSTRUCT lParam) {
        MouseWheelListener[] listeners;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("fireMouseWheelEvent(eventType=" + eventType + ",lParam=" + (Object)((Object)lParam) + ")"));
        }
        if ((listeners = (MouseWheelListener[])this.listenerList.getListeners(MouseWheelListener.class)).length > 0) {
            MouseWheelEvent evt = this.createMouseWheelEvent(eventType, lParam);
            for (int i = listeners.length - 1; i >= 0; --i) {
                switch (eventType) {
                    case 507: {
                        listeners[i].mouseWheelMoved(evt);
                    }
                }
            }
        }
    }

    private MouseEvent createMouseEvent(int eventType, int button, MSLLHOOKSTRUCT lParam) {
        User32.POINT pt = lParam.pt;
        Point rl = this.relativeTo.getLocationOnScreen();
        int x = pt.x - rl.x;
        int y = pt.y - rl.y;
        return new MouseEvent(this.relativeTo, eventType, lParam.time.longValue(), 0, x, y, pt.x, pt.y, 0, false, button);
    }

    private MouseWheelEvent createMouseWheelEvent(int eventType, MSLLHOOKSTRUCT lParam) {
        User32.POINT pt = lParam.pt;
        Point rl = this.relativeTo.getLocationOnScreen();
        int x = pt.x - rl.x;
        int y = pt.y - rl.y;
        int wheelRotation = lParam.mouseData.intValue() >> 16;
        return new MouseWheelEvent(this.relativeTo, eventType, lParam.time.longValue(), 0, x, y, pt.x, pt.y, 0, false, 0, 1, wheelRotation * -1);
    }

    private class MouseHookThread
    extends Thread {
        private MouseHookThread() {
        }

        public void run() {
            LOG.debug((Object)"run()");
            try {
                WindowsMouseHook.this.hHook = USER32_INSTANCE.SetWindowsHookEx(14, (User32.HOOKPROC)WindowsMouseHook.this, (W32API.HINSTANCE)Kernel32.INSTANCE.GetModuleHandle(null), 0);
                User32.MSG msg = new User32.MSG();
                while (USER32_INSTANCE.GetMessage(msg, null, 0, 0) != 0) {
                    USER32_INSTANCE.TranslateMessage(msg);
                    USER32_INSTANCE.DispatchMessage(msg);
                    if (WindowsMouseHook.this.getHook() != null) continue;
                    break;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            LOG.debug((Object)"mouse hook runnable exits");
        }
    }
}

